/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.runtime.services.background.BackgroundServiceDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.InitialisationSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.security.authentication.AuthenticationSession;

class ForkingInvocationHandler<T>
implements InvocationHandler {
    private final T target;
    private final Object mixedInIfAny;
    private final ExecutorService backgroundExecutorService;

    ForkingInvocationHandler(T target, Object mixedInIfAny, ExecutorService backgroundExecutorService) {
        this.target = _With.requires(target, (String)"target");
        this.mixedInIfAny = mixedInIfAny;
        this.backgroundExecutorService = (ExecutorService)_With.requires((Object)backgroundExecutorService, (String)"backgroundExecutorService");
    }

    @Override
    public Object invoke(Object proxied, Method proxyMethod, Object[] args) throws Throwable {
        boolean inheritedFromObject = proxyMethod.getDeclaringClass().equals(Object.class);
        if (inheritedFromObject) {
            return proxyMethod.invoke(this.target, args);
        }
        Object domainObject = this.mixedInIfAny == null ? this.target : this.mixedInIfAny;
        Optional<IsisSession> currentSession = Optional.ofNullable(IsisContext.getSessionFactory()).map(IsisSessionFactory::getCurrentSession);
        AuthenticationSession authSession = currentSession.map(IsisSession::getAuthenticationSession).orElse((AuthenticationSession)new InitialisationSession());
        CountDownLatch countDownLatch = currentSession.map(IsisSession::getCurrentTransaction).map(IsisTransaction::countDownLatch).orElse(new CountDownLatch(0));
        this.backgroundExecutorService.submit(() -> {
            try {
                countDownLatch.await();
                IsisContext.getSessionFactory().doInSession(() -> proxyMethod.invoke(domainObject, args), authSession);
            }
            catch (Exception e) {
                BackgroundServiceDefault.LOG.error(String.format("Background execution of action '%s' on object '%s' failed.", proxyMethod.getName(), domainObject.getClass().getName()), (Throwable)e);
            }
        });
        return null;
    }
}

