/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServicesInstallerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfiguration.class);
    private static final char DELIMITER = '#';

    private ServicesInstallerUtils() {
    }

    static <V extends Comparable<V>> LinkedHashSet<V> flatten(SortedMap<String, SortedSet<V>> positionedServices) {
        LinkedHashSet serviceList = _Sets.newLinkedHashSet();
        Set<String> keys = positionedServices.keySet();
        for (String position : keys) {
            SortedSet list = (SortedSet)positionedServices.get(position);
            serviceList.addAll(list);
        }
        return serviceList;
    }

    static <V> void appendInPosition(SortedMap<String, SortedSet<String>> positionedServices, String position, String service) {
        if (service == null) {
            return;
        }
        SortedSet serviceList = (SortedSet)positionedServices.get(position);
        if (serviceList == null) {
            serviceList = _Sets.newTreeSet();
            positionedServices.put(position, serviceList);
        }
        serviceList.add(service);
    }

    static Object instantiateService(String serviceName, ServiceInstantiator serviceInstantiator) {
        int pos = serviceName.indexOf(35);
        if (pos == 0) {
            return null;
        }
        String type = pos != -1 ? serviceName.substring(0, pos) : serviceName;
        return serviceInstantiator.createInstance(type);
    }

    static List<Object> instantiateServicesFrom(SortedMap<String, SortedSet<String>> positionedServices, ServiceInstantiator serviceInstantiator) {
        LinkedHashSet serviceNameList = ServicesInstallerUtils.flatten(positionedServices);
        return _NullSafe.stream(serviceNameList).map(ServicesInstallerUtils.instantiator(serviceInstantiator)).filter(_NullSafe::isPresent).collect(Collectors.toList());
    }

    private static Function<String, Object> instantiator(ServiceInstantiator serviceInstantiator) {
        return serviceName -> ServicesInstallerUtils.instantiateService(serviceName, serviceInstantiator);
    }
}

