/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.memento;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.memento.CollectionData;
import org.apache.isis.core.runtime.memento.Data;
import org.apache.isis.core.runtime.memento.ObjectData;
import org.apache.isis.core.runtime.memento.StandaloneData;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memento
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Memento.class);
    private static final long serialVersionUID = 1L;
    private final List<Oid> transientObjects = _Lists.newArrayList();
    private Data data;

    public Memento(ObjectAdapter adapter) {
        this.data = adapter == null ? null : this.createData(adapter);
        LOG.debug("created memento for {}", (Object)this);
    }

    private Data createData(ObjectAdapter adapter) {
        if (adapter.getSpecification().isParentedOrFreeCollection() && !adapter.getSpecification().isEncodeable()) {
            return this.createCollectionData(adapter);
        }
        return this.createObjectData(adapter);
    }

    private Data createCollectionData(ObjectAdapter adapter) {
        Data[] collData = (Data[])CollectionFacet.Utils.streamAdapters((ManagedObject)adapter).map(ref -> this.createReferenceData((ObjectAdapter)ref)).collect(_Arrays.toArray(Data.class, (int)CollectionFacet.Utils.size((ManagedObject)adapter)));
        String elementTypeSpecName = adapter.getSpecification().getFullIdentifier();
        return new CollectionData(Memento.clone(adapter.getOid()), elementTypeSpecName, collData);
    }

    private ObjectData createObjectData(ObjectAdapter adapter) {
        Oid adapterOid = Memento.clone(adapter.getOid());
        this.transientObjects.add(adapterOid);
        ObjectSpecification cls = adapter.getSpecification();
        ObjectData data = new ObjectData(adapterOid, cls.getFullIdentifier());
        Stream associations = cls.streamAssociations(Contributed.EXCLUDED);
        associations.filter(association -> {
            if (association.isNotPersisted()) {
                if (association.isOneToManyAssociation()) {
                    return false;
                }
                if (association.containsFacet(PropertyOrCollectionAccessorFacet.class) && !association.containsFacet(PropertySetterFacet.class)) {
                    LOG.debug("ignoring not-settable field {}", (Object)association.getName());
                    return false;
                }
            }
            return true;
        }).forEach(association -> this.createAssociationData(adapter, data, (ObjectAssociation)association));
        return data;
    }

    private void createAssociationData(ObjectAdapter adapter, ObjectData data, ObjectAssociation objectAssoc) {
        Object assocData;
        if (objectAssoc.isOneToManyAssociation()) {
            ObjectAdapter collAdapter = objectAssoc.get(adapter, InteractionInitiatedBy.FRAMEWORK);
            assocData = this.createCollectionData(collAdapter);
        } else if (objectAssoc.getSpecification().isEncodeable()) {
            EncodableFacet facet = (EncodableFacet)objectAssoc.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = objectAssoc.get(adapter, InteractionInitiatedBy.FRAMEWORK);
            assocData = facet.toEncodedString(value);
        } else if (objectAssoc.isOneToOneAssociation()) {
            ObjectAdapter referencedAdapter = objectAssoc.get(adapter, InteractionInitiatedBy.FRAMEWORK);
            assocData = this.createReferenceData(referencedAdapter);
        } else {
            throw new UnknownTypeException((Object)objectAssoc);
        }
        data.addField(objectAssoc.getId(), assocData);
    }

    private Data createReferenceData(ObjectAdapter referencedAdapter) {
        if (referencedAdapter == null) {
            return null;
        }
        Oid refOid = Memento.clone(referencedAdapter.getOid());
        if (refOid == null || refOid.isValue()) {
            return this.createStandaloneData(referencedAdapter);
        }
        if ((referencedAdapter.getSpecification().isParented() || refOid.isTransient()) && !this.transientObjects.contains(refOid)) {
            this.transientObjects.add(refOid);
            return this.createObjectData(referencedAdapter);
        }
        String specification = referencedAdapter.getSpecification().getFullIdentifier();
        return new Data(refOid, specification);
    }

    private static <T extends Oid> T clone(T oid) {
        if (oid == null) {
            return null;
        }
        return (T)((Oid)_Casts.uncheckedCast((Object)oid.copy()));
    }

    private Data createStandaloneData(ObjectAdapter adapter) {
        return new StandaloneData(adapter);
    }

    public Oid getOid() {
        return this.data.getOid();
    }

    protected Data getData() {
        return this.data;
    }

    public ObjectAdapter recreateObject() {
        if (this.data == null) {
            return null;
        }
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(this.data.getClassName());
        Oid oid = this.getOid();
        return this.getPersistenceSession().mementoSupport().recreateObject(spec, oid, this.data);
    }

    public String toString() {
        return "[" + (this.data == null ? null : this.data.getClassName() + "/" + this.data.getOid() + this.data) + "]";
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

