/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.memento;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.runtime.memento.Data;

public class CollectionData
extends Data {
    private static final long serialVersionUID = 1L;
    private final Data[] elements;

    public CollectionData(Oid oid, String className, Data[] elements) {
        super(oid, className);
        this.elements = elements;
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeEncodables((Object[])this.elements);
    }

    @Override
    public String toString() {
        return "(" + this.streamElements().map(data -> "" + data).collect(Collectors.joining(",")) + ")";
    }

    public Stream<Data> streamElements() {
        return _NullSafe.stream((Object[])this.elements);
    }

    public int getElementCount() {
        return _NullSafe.size((Object[])this.elements);
    }
}

