/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.services.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.confview.ConfigurationProperty;
import org.apache.isis.applib.services.confview.ConfigurationViewService;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.ConfigurationConstants;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ConfigurationViewServiceDefault
implements ConfigurationViewService {
    private _Lazy<Map<String, ConfigurationProperty>> config = _Lazy.of(this::loadConfiguration);

    public Set<ConfigurationProperty> allProperties() {
        return new TreeSet<ConfigurationProperty>(((Map)this.config.get()).values());
    }

    private Map<String, ConfigurationProperty> loadConfiguration() {
        HashMap<String, ConfigurationProperty> map = new HashMap<String, ConfigurationProperty>();
        _Config.getConfiguration().asMap().forEach((k, v) -> ConfigurationViewServiceDefault.add(k, v, map));
        ConfigurationViewServiceDefault.add("[ Isis Version ]", IsisConfiguration.getVersion(), map);
        ConfigurationViewServiceDefault.add("[ Deployment Type ]", _Context.getEnvironment().getDeploymentType().name(), map);
        ConfigurationViewServiceDefault.add("[ Unit Testing ]", "" + _Context.getEnvironment().isUnitTesting(), map);
        return map;
    }

    private static void add(String key, String value, Map<String, ConfigurationProperty> map) {
        value = ConfigurationConstants.maskIfProtected(key, value);
        map.put(key, new ConfigurationProperty(key, value));
    }
}

