/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.config.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceForWebInf
extends ResourceStreamSourceAbstract {
    public static final String DEFAULT_WEBINF_DIRECTORY = "/WEB-INF";
    private final ServletContext servletContext;
    private final String configurationDirectory;

    public ResourceStreamSourceForWebInf(ServletContext servletContext) {
        this(servletContext, DEFAULT_WEBINF_DIRECTORY);
    }

    public ResourceStreamSourceForWebInf(ServletContext servletContext, String configurationDirectory) {
        this.servletContext = servletContext;
        this.configurationDirectory = configurationDirectory;
    }

    @Override
    public String getName() {
        return "servlet context ('" + this.configurationDirectory + "')";
    }

    @Override
    public InputStream doReadResource(String resourcePath) throws IOException {
        String fullyQualifiedResourcePath = _Resources.combinePath((String)this.configurationDirectory, (String)resourcePath);
        return this.servletContext.getResourceAsStream(fullyQualifiedResourcePath);
    }
}

