/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.resource;

import java.io.InputStream;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.config.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceContextLoaderClassPath
extends ResourceStreamSourceAbstract {
    private final String prefix;

    public static ResourceStreamSourceContextLoaderClassPath create() {
        return ResourceStreamSourceContextLoaderClassPath.create("");
    }

    public static ResourceStreamSourceContextLoaderClassPath create(String prefix) {
        return new ResourceStreamSourceContextLoaderClassPath(prefix);
    }

    private ResourceStreamSourceContextLoaderClassPath(String prefix) {
        this.prefix = prefix;
    }

    @Override
    protected InputStream doReadResource(String resourcePath) {
        ClassLoader classLoader = _Context.getDefaultClassLoader();
        String path = _Resources.combinePath((String)this.prefix, (String)resourcePath);
        return classLoader.getResourceAsStream(path);
    }

    @Override
    public String getName() {
        return "context loader classpath";
    }
}

