/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.resource;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.isis.config.resource.ResourceStreamSource;
import org.apache.isis.config.resource.ResourceStreamSourceAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamSourceComposite
extends ResourceStreamSourceAbstract {
    private static Logger LOG = LoggerFactory.getLogger(ResourceStreamSourceComposite.class);
    private final List<ResourceStreamSource> resourceStreamSources = new ArrayList<ResourceStreamSource>();

    public ResourceStreamSourceComposite(ResourceStreamSource ... resourceStreamSources) {
        for (ResourceStreamSource rss : resourceStreamSources) {
            this.addResourceStreamSource(rss);
        }
    }

    public void addResourceStreamSource(ResourceStreamSource rss) {
        this.resourceStreamSources.add(rss);
    }

    @Override
    protected InputStream doReadResource(String resourcePath) {
        Vector<InputStream> compositionStreams = new Vector<InputStream>();
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            InputStream resourceStream = rss.readResource(resourcePath);
            if (resourceStream == null) continue;
            compositionStreams.add(resourceStream);
        }
        if (!compositionStreams.isEmpty()) {
            return new SequenceInputStream(compositionStreams.elements());
        }
        LOG.debug("could not load resource path '{}' from {}", (Object)resourcePath, (Object)this.getName());
        return null;
    }

    @Override
    public OutputStream writeResource(String resourcePath) {
        return null;
    }

    @Override
    public String getName() {
        return "composite [" + this.resourceStreamNames() + "]";
    }

    private String resourceStreamNames() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(rss.getName());
        }
        return buf.toString();
    }
}

