/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.isis.config.resource.ResourceStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ResourceStreamSourceAbstract
implements ResourceStreamSource {
    private static Logger LOG = LoggerFactory.getLogger(ResourceStreamSourceAbstract.class);

    ResourceStreamSourceAbstract() {
    }

    @Override
    public final InputStream readResource(String resourcePath) {
        try {
            InputStream resourceStream = this.doReadResource(resourcePath);
            if (resourceStream != null) {
                return resourceStream;
            }
            LOG.debug("could not load resource path '{}' from {}", (Object)resourcePath, (Object)this.getName());
        }
        catch (IOException e) {
            LOG.debug("could not load resource path '{}' from {}, exception: {}", new Object[]{resourcePath, this.getName(), e.getMessage()});
        }
        return null;
    }

    protected abstract InputStream doReadResource(String var1) throws IOException;

    @Override
    public OutputStream writeResource(String resourcePath) {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

