/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.internal;

import java.util.Optional;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.slf4j.LoggerFactory;

class _Config_LifecycleResource {
    private final IsisConfigurationBuilder builder;
    private final _Lazy<IsisConfiguration> configuration;
    private IllegalStateException configurationBuildStacktrace;

    _Config_LifecycleResource(IsisConfigurationBuilder builder) {
        _With.requires((Object)builder, (String)"builder");
        this.builder = builder;
        this.configuration = _Lazy.threadSafe(this::build);
    }

    IsisConfiguration getConfiguration() {
        return (IsisConfiguration)this.configuration.get();
    }

    Optional<IsisConfigurationBuilder> getBuilder() {
        if (!this.configuration.isMemoized()) {
            return Optional.of(this.builder);
        }
        return Optional.empty();
    }

    private IsisConfiguration build() {
        try {
            throw new IllegalStateException("IsisConfiguration Build (previously already triggered by ...)");
        }
        catch (IllegalStateException e) {
            this.configurationBuildStacktrace = e;
            LoggerFactory.getLogger(IsisConfiguration.class).info("=== BUILT/DONE ===");
            return this.builder.build();
        }
    }

    IllegalStateException configurationAlreadyInUse() {
        IllegalStateException cause = this.configurationBuildStacktrace;
        return new IllegalStateException("The IsisConfigurationBuilder is no longer valid, because it has already built the IsisConfiguration for this application's life-cycle.", cause);
    }
}

