/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.builder.IsisConfigurationBuilder;

class PrimerForSystemProperties
implements IsisConfigurationBuilder.Primer {
    PrimerForSystemProperties() {
    }

    @Override
    public void prime(IsisConfigurationBuilder builder) {
        Properties properties = System.getProperties();
        for (Map.Entry<String, String> entry : PrimerForSystemProperties.fromProperties(properties).entrySet()) {
            String envVarName = entry.getKey();
            String envVarValue = entry.getValue();
            if (!envVarName.startsWith("isis.")) continue;
            builder.put(envVarName, envVarValue);
        }
    }

    private static Map<String, String> fromProperties(Properties properties) {
        LinkedHashMap map = _Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            map.put((String)key, (String)value);
        }
        return map;
    }
}

