/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.apache.isis.config.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.config.resource.ResourceStreamSourceCurrentClassClassPath;
import org.apache.isis.config.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.config.resource.ResourceStreamSourceForWebInf;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrimerForServletContext
implements IsisConfigurationBuilder.Primer {
    private static final Logger LOG = LoggerFactory.getLogger(PrimerForServletContext.class);

    PrimerForServletContext() {
    }

    @Override
    public void prime(IsisConfigurationBuilder builder) {
        ServletContext servletContext = (ServletContext)_Context.getIfAny(ServletContext.class);
        if (servletContext == null) {
            LOG.info("No servlet context found to prime configuration from.");
            return;
        }
        LOG.info("Priming configuration from servlet context ...");
        PrimerForServletContext.asMap(servletContext).forEach((k, v) -> builder.put((String)k, (String)v));
        PrimerForServletContext.addServletContextConstants(servletContext, builder);
        PrimerForServletContext.addResourceStreamSources(servletContext, builder);
        String loggingPropertiesDir = (String)_With.ifPresentElseGet((Object)servletContext.getInitParameter("isis.config.dir"), () -> servletContext.getRealPath("/WEB-INF"));
        IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
        loggingConfigurer.configureLogging(loggingPropertiesDir, new String[0]);
    }

    private static Map<String, String> asMap(ServletContext servletContext) {
        Enumeration initParameterNames = servletContext.getInitParameterNames();
        TreeMap map = _Maps.newTreeMap();
        while (initParameterNames.hasMoreElements()) {
            String initParameterName = (String)initParameterNames.nextElement();
            String initParameterValue = servletContext.getInitParameter(initParameterName);
            if (!initParameterName.startsWith("isis.")) continue;
            map.put(initParameterName, initParameterValue);
        }
        return map;
    }

    private static void addServletContextConstants(ServletContext servletContext, IsisConfigurationBuilder isisConfigurationBuilder) {
        String webappDir = servletContext.getRealPath("/");
        isisConfigurationBuilder.add("application.webapp.dir", webappDir);
    }

    private static void addResourceStreamSources(ServletContext servletContext, IsisConfigurationBuilder builder) {
        String configLocation = servletContext.getInitParameter("isis.config.dir");
        if (configLocation != null) {
            LOG.info("Config override location: {}", (Object)configLocation);
            builder.addResourceStreamSource(ResourceStreamSourceFileSystem.create(configLocation));
        } else {
            LOG.info("Config override location: No override location configured");
            builder.addResourceStreamSource(ResourceStreamSourceContextLoaderClassPath.create());
            builder.addResourceStreamSource(new ResourceStreamSourceCurrentClassClassPath());
            builder.addResourceStreamSource(new ResourceStreamSourceForWebInf(servletContext));
        }
    }
}

