/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.builder.IsisConfigurationBuilder;

class PrimerForEnvironmentVariableISIS_OPTS
implements IsisConfigurationBuilder.Primer {
    public static final String OPT_ENV = "ISIS_OPTS";
    public static final String SEPARATOR_ENV = "ISIS_OPTS_SEPARATOR";
    public static final String SEPARATOR_DEFAULT = "||";

    PrimerForEnvironmentVariableISIS_OPTS() {
    }

    @Override
    public void prime(IsisConfigurationBuilder builder) {
        String separator = this.determineSeparator();
        String optEnv = OPT_ENV;
        String env = this.getEnv(OPT_ENV);
        for (Map.Entry<String, String> entry : PrimerForEnvironmentVariableISIS_OPTS.fromEnv(env, separator).entrySet()) {
            String envVarName = entry.getKey();
            String envVarValue = entry.getValue();
            builder.put(envVarName, envVarValue);
        }
    }

    String getEnv(String optEnv) {
        return System.getenv(optEnv);
    }

    private String determineSeparator() {
        String separator = this.getEnv(SEPARATOR_ENV);
        if (separator != null) {
            return separator;
        }
        return SEPARATOR_DEFAULT;
    }

    private static Map<String, String> fromEnv(String env, String separator) {
        LinkedHashMap map = _Maps.newLinkedHashMap();
        if (env != null) {
            _Strings.splitThenStream((String)env, (String)separator).forEach(keyAndValue -> {
                List parts = _Strings.splitThenStream((String)env, (String)"=").collect(Collectors.toList());
                if (parts.size() >= 2) {
                    String key = (String)parts.get(0);
                    String value = parts.stream().skip(1L).collect(Collectors.joining("="));
                    map.put(key, value);
                }
            });
        }
        return map;
    }
}

