/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.ViewModel;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.applib.fixturescripts.DiscoverableFixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.config.builder.PersistenceCapableTypeFinder;
import org.apache.isis.core.plugins.classdiscovery.ClassDiscovery;
import org.apache.isis.core.plugins.classdiscovery.ClassDiscoveryPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModulePackageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ModulePackageHelper.class);

    ModulePackageHelper() {
    }

    public static int runTypeDiscovery(AppManifest appManifest) {
        List<String> moduleAndFrameworkPackages = ModulePackageHelper.findAndRegisterTypes(appManifest);
        return moduleAndFrameworkPackages.size();
    }

    private static Stream<String> modulePackageNamesFrom(AppManifest appManifest) {
        List modules = appManifest.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("If an appManifest is provided then it must return a non-empty set of modules");
        }
        return modules.stream().map(Class::getPackage).map(Package::getName);
    }

    private static List<String> findAndRegisterTypes(AppManifest appManifest) {
        _With.requires((Object)appManifest, (String)"appManifest");
        LOG.info(String.format("Discover the application's domain and register all types using manifest '%s' ...", appManifest.getClass().getName()));
        AppManifest.Registry registry = AppManifest.Registry.instance();
        ArrayList moduleAndFrameworkPackages = _Lists.newArrayList();
        moduleAndFrameworkPackages.addAll(AppManifest.Registry.FRAMEWORK_PROVIDED_SERVICE_PACKAGES);
        ModulePackageHelper.modulePackageNamesFrom(appManifest).forEach(moduleAndFrameworkPackages::add);
        ClassDiscovery discovery = ClassDiscoveryPlugin.get().discover((List)moduleAndFrameworkPackages);
        LinkedHashSet domainServiceTypes = _Sets.newLinkedHashSet();
        domainServiceTypes.addAll(discovery.getTypesAnnotatedWith(DomainService.class));
        domainServiceTypes.addAll(discovery.getTypesAnnotatedWith(DomainServiceLayout.class));
        Set persistenceCapableTypes = PersistenceCapableTypeFinder.find(discovery);
        Set fixtureScriptTypes = discovery.getSubTypesOf(FixtureScript.class).stream().filter(aClass -> DiscoverableFixtureScript.class.isAssignableFrom((Class<?>)aClass) || _Reflect.getAnnotation((Class)aClass, Programmatic.class) == null).collect(Collectors.toSet());
        LinkedHashSet domainObjectTypes = _Sets.newLinkedHashSet();
        domainObjectTypes.addAll(discovery.getTypesAnnotatedWith(DomainObject.class));
        domainObjectTypes.addAll(discovery.getTypesAnnotatedWith(DomainObjectLayout.class));
        HashSet mixinTypes = _Sets.newHashSet();
        mixinTypes.addAll(discovery.getTypesAnnotatedWith(Mixin.class));
        domainObjectTypes.stream().filter(input -> {
            DomainObject annotation = input.getAnnotation(DomainObject.class);
            return annotation != null && annotation.nature() == Nature.MIXIN;
        }).forEach(mixinTypes::add);
        LinkedHashSet viewModelTypes = _Sets.newLinkedHashSet();
        viewModelTypes.addAll(discovery.getTypesAnnotatedWith(ViewModel.class));
        viewModelTypes.addAll(discovery.getTypesAnnotatedWith(ViewModelLayout.class));
        LinkedHashSet xmlElementTypes = _Sets.newLinkedHashSet();
        xmlElementTypes.addAll(discovery.getTypesAnnotatedWith(XmlElement.class));
        domainServiceTypes.addAll(appManifest.getAdditionalServices());
        List<String> packagesWithDotSuffix = moduleAndFrameworkPackages.stream().map(s -> s != null ? s + "." : null).collect(Collectors.toList());
        registry.setDomainServiceTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, domainServiceTypes));
        registry.setPersistenceCapableTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, persistenceCapableTypes));
        registry.setFixtureScriptTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, fixtureScriptTypes));
        registry.setMixinTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, mixinTypes));
        registry.setDomainObjectTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, domainObjectTypes));
        registry.setViewModelTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, viewModelTypes));
        registry.setXmlElementTypes(ModulePackageHelper.withinPackageAndNotAnonymous(packagesWithDotSuffix, xmlElementTypes));
        return moduleAndFrameworkPackages;
    }

    static <T> Set<Class<? extends T>> withinPackageAndNotAnonymous(Collection<String> packageNames, Set<Class<? extends T>> classes) {
        LinkedHashSet classesWithin = _Sets.newLinkedHashSet();
        for (Class<T> clz : classes) {
            String className = clz.getName();
            if (!ModulePackageHelper.containedWithin(packageNames, className) || !ModulePackageHelper.notAnonymous(clz)) continue;
            classesWithin.add(clz);
        }
        return classesWithin;
    }

    private static boolean containedWithin(Collection<String> packageNames, String className) {
        for (String packageName : packageNames) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        LOG.warn("Skipping a service for registration because due to not being part of the packagess to include: " + className);
        return false;
    }

    private static <T> boolean notAnonymous(Class<? extends T> clz) {
        try {
            return !clz.isAnonymousClass();
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }
}

