/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.ConfigurationConstants;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.IsisConfigurationException;
import org.apache.isis.config.builder.ModulePackageHelper;
import org.apache.isis.config.resource.ResourceStreamSource;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainObject(nature=Nature.INMEMORY_ENTITY, objectType="internal.IsisConfiguration")
class IsisConfigurationDefault
implements IsisConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationDefault.class);
    private final ResourceStreamSource resourceStreamSource;
    private final Properties properties = new Properties();
    private Properties applicationProperties;
    private AppManifest appManifest;
    _Lazy<Integer> typeDiscovery = _Lazy.threadSafe(() -> ModulePackageHelper.runTypeDiscovery(this.getAppManifest()));

    public IsisConfigurationDefault() {
        this(null);
    }

    public IsisConfigurationDefault(ResourceStreamSource resourceStreamSource) {
        this.resourceStreamSource = resourceStreamSource;
        LOG.debug("configuration initialised with stream: {}", (Object)this.nameOf(resourceStreamSource));
    }

    private String nameOf(ResourceStreamSource resourceStreamSource) {
        return resourceStreamSource != null ? resourceStreamSource.getName() : null;
    }

    @Override
    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    public void setAppManifest(AppManifest appManifest) {
        _With.requires((Object)appManifest, (String)"appManifest");
        this.appManifest = appManifest;
    }

    public void triggerTypeDiscovery() {
        this.typeDiscovery.get();
    }

    @Override
    public ResourceStreamSource getResourceStreamSource() {
        return this.resourceStreamSource;
    }

    public void add(Properties properties, IsisConfiguration.ContainsPolicy containsPolicy) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            this.addPerPolicy((String)key, (String)value, containsPolicy);
        }
    }

    public void add(String key, String value) {
        this.addPerPolicy(key, value, IsisConfiguration.ContainsPolicy.IGNORE);
    }

    public void put(String key, String value) {
        this.addPerPolicy(key, value, IsisConfiguration.ContainsPolicy.OVERWRITE);
    }

    private void addPerPolicy(String key, String value, IsisConfiguration.ContainsPolicy policy) {
        if (value == null) {
            LOG.debug("ignoring {} as value is null", (Object)key);
            return;
        }
        if (key == null) {
            return;
        }
        if (this.properties.containsKey(key)) {
            switch (policy) {
                case IGNORE: {
                    LOG.debug("ignoring '{}' = '{}' as value already set (with '{}')", new Object[]{key, value, this.properties.get(key)});
                    break;
                }
                case OVERWRITE: {
                    LOG.debug("overwriting '{}' = '{}' (previous value was '{}')", new Object[]{key, value, this.properties.get(key)});
                    this.properties.put(key, value);
                    break;
                }
                case EXCEPTION: {
                    throw new IllegalStateException(String.format("Configuration already has a key {}, value of {}%s, value of %s", key, this.properties.get(key)));
                }
            }
        } else {
            LOG.debug("adding '{}' = '{}'", (Object)key, (Object)ConfigurationConstants.maskIfProtected(key, value));
            this.properties.put(key, value);
        }
    }

    @Override
    public IsisConfiguration createSubset(String prefix) {
        IsisConfigurationDefault subset = new IsisConfigurationDefault(this.resourceStreamSource);
        String startsWith = prefix;
        if (!startsWith.endsWith(".")) {
            startsWith = startsWith + '.';
        }
        int prefixLength = startsWith.length();
        for (Object keyObj : this.properties.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(startsWith)) continue;
            String modifiedKey = key.substring(prefixLength);
            subset.properties.put(modifiedKey, this.properties.get(key));
        }
        return subset;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getPropertyElseNull(name);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return defaultValue;
        }
        if ((value = value.toLowerCase()).equals("on") || value.equals("yes") || value.equals("true")) {
            return true;
        }
        if (value.equals("off") || value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new IsisConfigurationException("Illegal flag for " + name + "; must be one of on, off, yes, no, true or false");
    }

    @Override
    public Color getColor(String name) {
        return this.getColor(name, null);
    }

    @Override
    public Color getColor(String name, Color defaultValue) {
        String color = this.getPropertyElseNull(name);
        if (color == null) {
            return defaultValue;
        }
        return Color.decode(color);
    }

    @Override
    public Font getFont(String name) {
        return this.getFont(name, null);
    }

    @Override
    public Font getFont(String name, Font defaultValue) {
        String font = this.getPropertyElseNull(name);
        if (font == null) {
            return defaultValue;
        }
        return Font.decode(font);
    }

    @Override
    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        String value = this.getPropertyElseNull(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    @Override
    public String[] getList(String name) {
        String listAsCommaSeparatedArray = this.getString(name);
        return this.stringAsList(listAsCommaSeparatedArray);
    }

    @Override
    public String[] getList(String name, String defaultListAsCommaSeparatedArray) {
        String listAsCommaSeparatedArray = this.getString(name, defaultListAsCommaSeparatedArray);
        return this.stringAsList(listAsCommaSeparatedArray);
    }

    private String[] stringAsList(String list) {
        if (list == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        String[] array = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i++] = tokens.nextToken().trim();
        }
        return array;
    }

    @Override
    public IsisConfiguration getProperties(String withPrefix) {
        int prefixLength = "".length();
        Properties properties = new Properties();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(withPrefix)) continue;
            String modifiedKey = key.substring(prefixLength);
            properties.put(modifiedKey, this.properties.get(key));
        }
        IsisConfigurationDefault isisConfigurationDefault = new IsisConfigurationDefault(this.resourceStreamSource);
        isisConfigurationDefault.add(properties, IsisConfiguration.ContainsPolicy.IGNORE);
        return isisConfigurationDefault;
    }

    private String getPropertyElseNull(String name) {
        return this.getProperty(name, null);
    }

    private String getProperty(String name, String defaultValue) {
        String key = this.referedToAs(name);
        if (key.indexOf("..") >= 0) {
            throw new IsisException("property names should not have '..' within them: " + name);
        }
        String property = this.properties.getProperty(key, defaultValue);
        property = property != null ? property.trim() : null;
        LOG.debug("get property: '{} = '{}'", (Object)key, (Object)property);
        return property;
    }

    @Override
    public String getString(String name) {
        return this.getPropertyElseNull(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getProperty(name, defaultValue);
    }

    @Override
    public boolean hasProperty(String name) {
        String key = this.referedToAs(name);
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.asIterable().iterator();
    }

    @Override
    public Iterable<String> asIterable() {
        return this.properties.stringPropertyNames();
    }

    private String referedToAs(String name) {
        return name;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return "ConfigurationParameters [properties=" + this.properties + "]";
    }

    @Override
    public Map<String, String> asMap() {
        HashMap map = _Maps.newHashMap();
        for (String propertyName : this.asIterable()) {
            String propertyValue = this.getPropertyElseNull(propertyName);
            map.put(propertyName, propertyValue);
        }
        return map;
    }

    public String getProperty(String name) {
        this.initAppPropertiesIfRequired();
        return this.applicationProperties.getProperty(name);
    }

    private void initAppPropertiesIfRequired() {
        if (this.applicationProperties == null) {
            this.applicationProperties = this.deriveApplicationProperties();
        }
    }

    private Properties deriveApplicationProperties() {
        Properties applicationProperties = new Properties();
        IsisConfiguration applicationConfiguration = this.getProperties("application");
        for (String key : applicationConfiguration.asIterable()) {
            String value = applicationConfiguration.getString(key);
            String newKey = key.substring("application.".length());
            applicationProperties.setProperty(newKey, value);
        }
        return applicationProperties;
    }

    public List<String> getPropertyNames() {
        this.initAppPropertiesIfRequired();
        ArrayList list = _Lists.newArrayList();
        for (Object key : this.applicationProperties.keySet()) {
            list.add((String)key);
        }
        return list;
    }
}

