/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config.builder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifestAbstract2;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.NotFoundPolicy;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.apache.isis.config.builder.IsisConfigurationDefault;
import org.apache.isis.config.builder.PrimerForEnvironmentVariableISIS_OPTS;
import org.apache.isis.config.builder.PrimerForEnvironmentVariablesIsisPrefix;
import org.apache.isis.config.builder.PrimerForServletContext;
import org.apache.isis.config.builder.PrimerForSystemProperties;
import org.apache.isis.config.builder.PropertiesReader;
import org.apache.isis.config.resource.ResourceStreamSource;
import org.apache.isis.config.resource.ResourceStreamSourceChainOfResponsibility;
import org.apache.isis.config.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.config.resource.ResourceStreamSource_UsingClass;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IsisConfigurationBuilderDefault
implements IsisConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationBuilderDefault.class);
    private final ResourceStreamSourceChainOfResponsibility resourceStreamSourceChain;
    private IsisConfigurationDefault configuration;
    private final Set<String> configurationResourcesFound = _Sets.newLinkedHashSet();
    private final Set<String> configurationResourcesNotFound = _Sets.newLinkedHashSet();

    static IsisConfigurationBuilder empty() {
        ResourceStreamSourceChainOfResponsibility chain = IsisConfigurationBuilderDefault.createComposite(Collections.emptyList());
        IsisConfigurationBuilderDefault builder = new IsisConfigurationBuilderDefault(chain);
        return builder;
    }

    static IsisConfigurationBuilder getDefault() {
        if (_Context.isUnitTesting()) {
            return IsisConfigurationBuilderDefault.empty();
        }
        ResourceStreamSourceChainOfResponsibility chain = IsisConfigurationBuilderDefault.createComposite(Arrays.asList(ResourceStreamSourceFileSystem.create("config")));
        IsisConfigurationBuilderDefault builder = new IsisConfigurationBuilderDefault(chain);
        builder.addDefaultPrimers();
        builder.addTopLevelDefaultConfigurationResource();
        builder.addDefaultConfigurationResources();
        return builder;
    }

    private IsisConfigurationBuilderDefault(ResourceStreamSourceChainOfResponsibility resourceStreamSourceChain) {
        this.resourceStreamSourceChain = resourceStreamSourceChain;
        this.configuration = new IsisConfigurationDefault(resourceStreamSourceChain);
    }

    private static ResourceStreamSourceChainOfResponsibility createComposite(List<ResourceStreamSource> resourceStreamSources) {
        ResourceStreamSourceChainOfResponsibility composite = new ResourceStreamSourceChainOfResponsibility(new ResourceStreamSource[0]);
        for (ResourceStreamSource rss : resourceStreamSources) {
            if (rss == null) continue;
            composite.addResourceStreamSource(rss);
        }
        return composite;
    }

    private void addTopLevelDefaultConfigurationResource() {
        this.addConfigurationResource("isis.properties", NotFoundPolicy.FAIL_FAST, IsisConfiguration.ContainsPolicy.IGNORE);
    }

    private void addDefaultConfigurationResources() {
        IsisConfiguration.ContainsPolicy ignorePolicy = IsisConfiguration.ContainsPolicy.IGNORE;
        NotFoundPolicy continuePolicy = NotFoundPolicy.CONTINUE;
        this.addConfigurationResource("web.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("war.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_wicket.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_restful.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_restfulobjects.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("persistor_datanucleus.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("persistor.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication_shiro.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication_bypass.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization_shiro.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization_bypass.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("reflector_java.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("reflector.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("fixtures-installer_configuration.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("fixtures-installer.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_annotation.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_configuration.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_configuration-and-annotation.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("override.properties", NotFoundPolicy.CONTINUE, IsisConfiguration.ContainsPolicy.OVERWRITE);
        this.addConfigurationResource("overrides.properties", NotFoundPolicy.CONTINUE, IsisConfiguration.ContainsPolicy.OVERWRITE);
    }

    private void addDefaultPrimers() {
        this.primeWith(new PrimerForSystemProperties());
        this.primeWith(new PrimerForEnvironmentVariablesIsisPrefix());
        this.primeWith(new PrimerForEnvironmentVariableISIS_OPTS());
        this.primeWith(new PrimerForServletContext());
    }

    @Override
    public IsisConfigurationBuilder addResourceStreamSource(ResourceStreamSource resourceStreamSource) {
        this.addResourceStreamSources(resourceStreamSource);
        return this;
    }

    @Override
    public IsisConfigurationBuilder addResourceStreamSources(ResourceStreamSource ... resourceStreamSources) {
        this.addResourceStreamSources(Arrays.asList(resourceStreamSources));
        return this;
    }

    @Override
    public IsisConfigurationBuilder addResourceStreamSources(List<ResourceStreamSource> resourceStreamSources) {
        for (ResourceStreamSource resourceStreamSource : resourceStreamSources) {
            this.resourceStreamSourceChain.addResourceStreamSource(resourceStreamSource);
        }
        return this;
    }

    @Override
    public IsisConfigurationBuilder addConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy, IsisConfiguration.ContainsPolicy containsPolicy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("checking availability of configuration resource: %s, notFoundPolicy: %s", new Object[]{configurationResource, notFoundPolicy}));
        }
        this.loadConfigurationResource(configurationResource, notFoundPolicy, containsPolicy);
        return this;
    }

    private void loadConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy, IsisConfiguration.ContainsPolicy containsPolicy) {
        try {
            PropertiesReader propertiesReader = this.loadConfigurationResource(this.resourceStreamSourceChain, configurationResource);
            LOG.info("loading properties from {}", (Object)configurationResource);
            this.configuration.add(propertiesReader.getProperties(), containsPolicy);
            this.configurationResourcesFound.add(configurationResource);
            return;
        }
        catch (IOException iOException) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new IsisException(String.format("failed to load '%s'; tried using: %s", configurationResource, this.resourceStreamSourceChain.getName()));
            }
            this.configurationResourcesNotFound.add(configurationResource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("'{}' not found, but not needed", (Object)configurationResource);
            }
            return;
        }
    }

    private PropertiesReader loadConfigurationResource(ResourceStreamSource resourceStreamSource, String configurationResource) throws IOException {
        return new PropertiesReader(resourceStreamSource, configurationResource);
    }

    @Override
    public IsisConfigurationBuilder add(String key, String value) {
        this.configuration.add(key, value);
        return this;
    }

    @Override
    public IsisConfigurationBuilder put(String key, String value) {
        this.configuration.put(key, value);
        return this;
    }

    @Override
    public IsisConfigurationBuilder primeWith(IsisConfigurationBuilder.Primer primer) {
        LOG.debug("priming configurations for '{}'", (Object)primer);
        primer.prime(this);
        return this;
    }

    @Override
    public IsisConfigurationBuilder addTopModule(Module topModule) {
        AppManifestAbstract2.Builder manifestBuilder = AppManifestAbstract2.Builder.forModule((Module)topModule);
        AppManifestAbstract2 manifest = new AppManifestAbstract2(manifestBuilder){};
        this.addAppManifest((AppManifest)manifest);
        return this;
    }

    @Override
    public IsisConfigurationBuilder addAppManifest(AppManifest appManifest) {
        this.configuration.setAppManifest(appManifest);
        appManifest.getConfigurationProperties().forEach(this::put);
        return this;
    }

    @Override
    public IsisConfigurationBuilder addPropertyResource(PropertyResource propertyResource) {
        IsisConfiguration.ContainsPolicy ignorePolicy = IsisConfiguration.ContainsPolicy.IGNORE;
        NotFoundPolicy continuePolicy = NotFoundPolicy.CONTINUE;
        this.addResourceStreamSource(new ResourceStreamSource_UsingClass(propertyResource.getResourceContext()));
        this.addConfigurationResource(propertyResource.getResourceName(), continuePolicy, ignorePolicy);
        return this;
    }

    @Override
    public String peekAtString(String key) {
        return this.configuration.getString(key);
    }

    @Override
    public String peekAtString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    @Override
    public boolean peekAtBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    @Override
    public boolean peekAtBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    @Override
    public String[] peekAtList(String key) {
        return this.configuration.getList(key);
    }

    @Override
    public IsisConfiguration build() {
        if (this.configuration.getAppManifest() != null) {
            this.configuration.triggerTypeDiscovery();
        } else {
            LOG.info("Skipping domain type discovery due to missing AppManifest.");
        }
        if (LOG.isDebugEnabled()) {
            this.dumpResourcesToLog();
        }
        IsisConfigurationDefault ref = this.configuration;
        this.configuration = null;
        return ref;
    }

    @Override
    public void dumpResourcesToLog() {
        LOG.info("Configuration resources FOUND:");
        for (String resource : this.configurationResourcesFound) {
            LOG.info("*  {}", (Object)resource);
        }
        LOG.info("Configuration resources NOT FOUND (but not needed):");
        for (String resource : this.configurationResourcesNotFound) {
            LOG.info("*  {}", (Object)resource);
        }
    }

    public String toString() {
        return String.format("IsisConfigurationBuilder {resourceStream=%s, configResources=%s}", this.resourceStreamSourceChain, this.configurationResourcesFound);
    }
}

