/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config;

import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.config.internal._Config;
import org.apache.isis.config.resource.ResourceStreamSource;

public interface IsisConfiguration {
    public static IsisConfiguration buildFromModuleTree(Module topModule, PropertyResource ... additionalPropertyResources) {
        _Config.clear();
        _Config.acceptBuilder(builder -> {
            _NullSafe.stream((Object[])additionalPropertyResources).forEach(builder::addPropertyResource);
            builder.addTopModule(topModule);
        });
        return _Config.getConfiguration();
    }

    public static IsisConfiguration buildFromAppManifest(AppManifest appManifest) {
        _Config.clear();
        _Config.acceptBuilder(builder -> builder.addAppManifest(appManifest));
        return _Config.getConfiguration();
    }

    public static String getVersion() {
        return "2.0.0-M2";
    }

    public AppManifest getAppManifest();

    public IsisConfiguration createSubset(String var1);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    public Color getColor(String var1);

    public Color getColor(String var1, Color var2);

    public Font getFont(String var1);

    public Font getFont(String var1, Font var2);

    public String[] getList(String var1);

    public String[] getList(String var1, String var2);

    public int getInteger(String var1);

    public int getInteger(String var1, int var2);

    public IsisConfiguration getProperties(String var1);

    public String getString(String var1);

    public String getString(String var1, String var2);

    public boolean hasProperty(String var1);

    public boolean isEmpty();

    public Iterator<String> iterator();

    public Iterable<String> asIterable();

    public int size();

    public ResourceStreamSource getResourceStreamSource();

    public Map<String, String> asMap();

    default public boolean explicitAnnotationsForActions() {
        return this.getBoolean("isis.reflector.explicitAnnotations.action");
    }

    public static enum ContainsPolicy {
        IGNORE,
        OVERWRITE,
        EXCEPTION;

    }
}

