/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;

public final class ConfigurationConstants {
    public static final String ROOT = "isis.";
    public static final String APP_MANIFEST_KEY = "isis.appManifest";
    public static final String LIST_SEPARATOR = ",";
    public static final String DELIMITER = ".";
    public static final String DEFAULT_CONFIG_DIRECTORY = "config";
    public static final String WEBINF_DIRECTORY = "WEB-INF";
    public static final String WEBINF_FULL_DIRECTORY = "src/main/webapp/WEB-INF";
    public static final String DEFAULT_CONFIG_FILE = "isis.properties";
    public static final String WEB_CONFIG_FILE = "web.properties";
    public static final List<String> PROTECTED_KEYS = _Lists.of((Object[])new String[]{"password", "apiKey", "authToken"});

    public static String maskIfProtected(String key, String value) {
        return ConfigurationConstants.isProtected(key) ? "********" : value;
    }

    public static Map<String, String> maskIfProtected(Map<String, String> inMap, Supplier<Map<String, String>> mapFactory) {
        Map<String, String> result = mapFactory.get();
        inMap.forEach((k, v) -> result.put((String)k, ConfigurationConstants.maskIfProtected(k, v)));
        return result;
    }

    private ConfigurationConstants() {
    }

    static boolean isProtected(String key) {
        if (_Strings.isNullOrEmpty((CharSequence)key)) {
            return false;
        }
        String toLowerCase = key.toLowerCase();
        for (String protectedKey : PROTECTED_KEYS) {
            if (!toLowerCase.contains(protectedKey.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

