/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.IsisConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppManifestFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AppManifestFinder.class);

    AppManifestFinder() {
    }

    static AppManifest findAppMainfestOrThrow() {
        Class appManifest;
        String manifestKey = "isis.appManifest";
        String appManifestClassName = _Strings.read((InputStream)_Context.getDefaultClassLoader().getResourceAsStream("/META-INF/app.manifest"), (Charset)StandardCharsets.UTF_8);
        if (_Strings.isNullOrEmpty((CharSequence)appManifestClassName)) {
            throw new IsisConfigurationException(String.format("Failed to find AppManifest from config properties. No value for key '%s' found.", "isis.appManifest"));
        }
        try {
            appManifest = _Context.loadClassAndInitialize((String)appManifestClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IsisConfigurationException(String.format("Failed to instantiate AppManifest from config value '%s'.", appManifestClassName));
        }
        return (AppManifest)_Casts.uncheckedCast((Object)appManifest);
    }

    static Optional<AppManifest> findAppMainfest() {
        try {
            return Optional.ofNullable(AppManifestFinder.findAppMainfestOrThrow());
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            return Optional.empty();
        }
    }
}

