/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.config;

import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.cdi._CDI;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.context._Plugin;
import org.apache.isis.config.AppConfig;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppConfigLocator {
    private static final Logger LOG = LoggerFactory.getLogger(AppConfigLocator.class);

    private AppConfigLocator() {
    }

    public static AppConfig getAppConfig() {
        return (AppConfig)_Context.computeIfAbsent(AppConfig.class, __ -> AppConfigLocator.lookupAppConfig());
    }

    private static AppConfig lookupAppConfig() {
        AppConfig appConfig = AppConfigLocator.lookupAppConfig_UsingCDI();
        if (appConfig != null) {
            LOG.info(String.format("Located AppConfig '%s' via CDI.", appConfig.getClass().getName()));
            return appConfig;
        }
        appConfig = AppConfigLocator.lookupAppConfig_UsingServiceLoader();
        if (appConfig != null) {
            LOG.info(String.format("Located AppConfig '%s' via ServiceLoader.", appConfig.getClass().getName()));
            return appConfig;
        }
        appConfig = AppConfigLocator.lookupAppConfig_UsingConfigProperties();
        if (appConfig != null) {
            LOG.info(String.format("Located AppConfig '%s' using config properties.", appConfig.getClass().getName()));
            return appConfig;
        }
        throw new IsisException("Failed to locate the AppManifest");
    }

    private static AppConfig lookupAppConfig_UsingCDI() {
        return _CDI.getManagedBean(AppConfig.class).orElse(null);
    }

    private static AppConfig lookupAppConfig_UsingServiceLoader() {
        return (AppConfig)_Plugin.getOrElse(AppConfig.class, ambiguousPlugins -> {
            throw _Plugin.ambiguityNonRecoverable(AppConfig.class, (Set)ambiguousPlugins);
        }, () -> null);
    }

    private static AppConfig lookupAppConfig_UsingConfigProperties() {
        AppManifest appManifest;
        Class appManifestClass;
        IsisConfigurationBuilder builder = IsisConfigurationBuilder.getDefault();
        String appManifestClassName = builder.peekAtString("isis.appManifest");
        try {
            appManifestClass = (Class)_Casts.uncheckedCast((Object)_Context.loadClassAndInitialize((String)appManifestClassName));
        }
        catch (ClassNotFoundException e) {
            throw new IsisException("Failed to locate the AppManifest using config properties.", (Throwable)e);
        }
        try {
            appManifest = (AppManifest)appManifestClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IsisException(String.format("Failed to create instance of AppManifest '%s'.", appManifestClass), (Throwable)e);
        }
        return () -> IsisConfiguration.buildFromAppManifest(appManifest);
    }
}

