/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.io.Serializable;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class Tooltips {
    public static void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(Tooltips.class, "isis-tooltips.css")));
    }

    public static void addTooltip(Component target, Model<String> tooltipTextModel) {
        if (tooltipTextModel == null) {
            return;
        }
        String tooltipText = (String)((Object)tooltipTextModel.getObject());
        Tooltips.addTooltip(target, tooltipText);
    }

    public static void addTooltip(Component target, String tooltipText) {
        if (_Strings.isNullOrEmpty((CharSequence)tooltipText)) {
            return;
        }
        TooltipBehavior tooltipBehavior = new TooltipBehavior((IModel)Model.of((Serializable)((Object)tooltipText)), Tooltips.createTooltipConfig());
        target.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" isis-component-with-tooltip"))});
        target.add(new Behavior[]{tooltipBehavior});
    }

    public static void clearTooltip(Component target) {
        target.getBehaviors(TooltipBehavior.class).forEach(xva$0 -> target.remove(new Behavior[]{xva$0}));
    }

    private static TooltipConfig createTooltipConfig() {
        return new TooltipConfig().withTrigger(TooltipConfig.OpenTrigger.hover).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.bottom).withAnimation(true);
    }
}

