/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber2;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormFeedbackPanel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormAbstract;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class PromptFormAbstract<T extends BookmarkableModel<ObjectAdapter> & IModel<ObjectAdapter>>
extends FormAbstract<ObjectAdapter>
implements ScalarModelSubscriber2 {
    private static final long serialVersionUID = 1L;
    private static final String ID_OK_BUTTON = "okButton";
    public static final String ID_CANCEL_BUTTON = "cancelButton";
    private static final String ID_FEEDBACK = "feedback";
    protected final List<ScalarPanelAbstract2> paramPanels = _Lists.newArrayList();
    private final Component parentPanel;
    private final WicketViewerSettings settings;
    private final T formExecutorContext;
    private final AjaxButton okButton;
    private final AjaxButton cancelButton;

    public PromptFormAbstract(String id, Component parentPanel, WicketViewerSettings settings, T model) {
        super(id, model);
        this.parentPanel = parentPanel;
        this.settings = settings;
        this.formExecutorContext = model;
        this.setOutputMarkupId(true);
        this.addParameters();
        FormFeedbackPanel formFeedback = new FormFeedbackPanel(ID_FEEDBACK);
        this.addOrReplace(new Component[]{formFeedback});
        this.okButton = this.addOkButton();
        this.cancelButton = this.addCancelButton();
        this.doConfigureOkButton(this.okButton);
        this.doConfigureCancelButton(this.cancelButton);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("Wicket.Event.publish(Isis.Topic.FOCUS_FIRST_PARAMETER, '%s')", this.getMarkupId())));
    }

    protected abstract void addParameters();

    protected AjaxButton addOkButton() {
        Object okButton = this.settings.isUseIndicatorForFormSubmit() ? new IndicatingAjaxButton(ID_OK_BUTTON, (IModel)new ResourceModel("okLabel")){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                PromptFormAbstract.this.onOkSubmittedOf(target, this.getForm(), (AjaxButton)this);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (PromptFormAbstract.this.settings.isPreventDoubleClickForFormSubmit()) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        } : new AjaxButton(ID_OK_BUTTON, (IModel)new ResourceModel("okLabel")){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                PromptFormAbstract.this.onOkSubmittedOf(target, this.getForm(), this);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (PromptFormAbstract.this.settings.isPreventDoubleClickForFormSubmit()) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        };
        okButton.add(new Behavior[]{new JGrowlBehaviour()});
        this.setDefaultButton((IFormSubmittingComponent)okButton);
        this.add(new Component[]{okButton});
        return okButton;
    }

    protected AjaxButton addCancelButton() {
        AjaxButton cancelButton = new AjaxButton(ID_CANCEL_BUTTON, (IModel)new ResourceModel("cancelLabel")){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                PromptFormAbstract.this.closePromptIfAny(target);
                PromptFormAbstract.this.onCancelSubmitted(target);
            }
        };
        cancelButton.setDefaultFormProcessing(false);
        if (((FormExecutorContext)this.formExecutorContext).getPromptStyle().isInlineOrInlineAsIfEdit()) {
            cancelButton.add(new Behavior[]{new FireOnEscapeKey(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void respond(AjaxRequestTarget target) {
                    PromptFormAbstract.this.onCancelSubmitted(target);
                }
            }});
        }
        this.add(new Component[]{cancelButton});
        return cancelButton;
    }

    protected void closePromptIfAny(AjaxRequestTarget target) {
        ActionPromptProvider promptProvider = ActionPromptProvider.Util.getFrom((Component)this.parentPanel);
        if (promptProvider != null) {
            promptProvider.closePrompt(target);
        }
    }

    protected void doConfigureOkButton(AjaxButton okButton) {
    }

    protected void doConfigureCancelButton(AjaxButton cancelButton) {
    }

    private UiHintContainer getPageUiHintContainerIfAny() {
        Page page = this.getPage();
        if (page instanceof EntityPage) {
            EntityPage entityPage = (EntityPage)page;
            return entityPage.getUiHintContainerIfAny();
        }
        return null;
    }

    private void onOkSubmittedOf(AjaxRequestTarget target, Form<?> form, AjaxButton okButton) {
        this.setLastFocusHint();
        FormExecutorDefault<T> formExecutor = new FormExecutorDefault<T>(this.getFormExecutorStrategy());
        boolean withinPrompt = ((FormExecutorContext)this.formExecutorContext).isWithinPrompt();
        boolean succeeded = formExecutor.executeAndProcessResults(target.getPage(), target, form, withinPrompt);
        if (succeeded) {
            this.completePrompt(target);
            okButton.send((IEventSink)target.getPage(), Broadcast.EXACT, this.newCompletedEvent(target, form));
            try {
                target.add(new Component[]{form});
            }
            catch (IllegalArgumentException cause) {
                _Exceptions.FluentException.of((Exception)cause).suppressIfMessageContains("Cannot update component because its page is not the same");
            }
        }
    }

    protected abstract FormExecutorStrategy<T> getFormExecutorStrategy();

    private void setLastFocusHint() {
        UiHintContainer entityModel = this.getPageUiHintContainerIfAny();
        if (entityModel == null) {
            return;
        }
        MarkupContainer parent = this.parentPanel.getParent();
        if (parent != null) {
            entityModel.setHint((Component)this.getPage(), "focus", parent.getPageRelativePath());
        }
    }

    protected abstract Object newCompletedEvent(AjaxRequestTarget var1, Form<?> var2);

    @Override
    public void onError(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
        if (scalarPanel != null) {
            target.add(new Component[]{scalarPanel});
        }
    }

    public void onCancelSubmitted(AjaxRequestTarget target) {
        this.setLastFocusHint();
        this.completePrompt(target);
    }

    private void completePrompt(AjaxRequestTarget target) {
        if (this.isWithinPrompt()) {
            ((FormExecutorContext)this.formExecutorContext).reset();
            this.rebuildGuiAfterInlinePromptDone(target);
        } else {
            this.closePromptIfAny(target);
        }
    }

    private boolean isWithinPrompt() {
        return FormExecutorContext.Util.isWithinPrompt((FormExecutorContext)((FormExecutorContext)this.formExecutorContext));
    }

    private void rebuildGuiAfterInlinePromptDone(AjaxRequestTarget target) {
        String id = this.parentPanel.getId();
        MarkupContainer parent = this.parentPanel.getParent();
        WebMarkupContainer replacementPropertyEditFormPanel = new WebMarkupContainer(id);
        replacementPropertyEditFormPanel.setVisible(false);
        parent.addOrReplace(new Component[]{replacementPropertyEditFormPanel});
        ((FormExecutorContext)this.formExecutorContext).getInlinePromptContext().onCancel();
        MarkupContainer scalarTypeContainer = ((FormExecutorContext)this.formExecutorContext).getInlinePromptContext().getScalarTypeContainer();
        if (scalarTypeContainer != null) {
            String markupId = scalarTypeContainer.getMarkupId();
            target.appendJavaScript((CharSequence)String.format("Wicket.Event.publish(Isis.Topic.FOCUS_FIRST_PROPERTY, '%s')", markupId));
        }
        target.add(new Component[]{parent});
    }

    private AjaxButton defaultSubmittingComponent() {
        return this.okButton;
    }

    protected void appendDefaultButtonField() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append("<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">");
        buffer.append("<input type=\"text\" tabindex=\"-1\" autocomplete=\"off\"/>");
        AjaxButton submittingComponent = this.defaultSubmittingComponent();
        buffer.append("<input type=\"submit\" tabindex=\"-1\" name=\"");
        buffer.append(this.defaultSubmittingComponent().getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&amp;&amp;b.onclick!=null&amp;&amp;typeof(b.onclick) != 'undefined') {  var r = Wicket.bind(b.onclick, b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
    }

    static abstract class FireOnEscapeKey
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private static final String PRE_JS = "$(document).ready( function() { \n  $(document).bind('keyup', function(evt) { \n    if (evt.keyCode == 27) { \n";
        private static final String POST_JS = "      evt.preventDefault(); \n       } \n  }); \n});";

        FireOnEscapeKey() {
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            String javascript = PRE_JS + this.getCallbackScript() + POST_JS;
            response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)javascript, null, null));
        }

        protected abstract void respond(AjaxRequestTarget var1);
    }
}

