/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.guice.GuiceBeanProvider;
import org.apache.isis.applib.services.hint.HintStore;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.actions.redirect.RedirectFacet;
import org.apache.isis.core.metamodel.facets.properties.renderunchanged.UnchangingFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.MessageBroker;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.FormExecutor;
import org.apache.isis.viewer.wicket.model.models.ParentEntityModelProvider;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib.IsisBlobOrClobPanelAbstract;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormExecutorDefault<M extends BookmarkableModel<ObjectAdapter>>
implements FormExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FormExecutorDefault.class);
    protected final M model;
    protected final WicketViewerSettings settings;
    private final FormExecutorStrategy<M> formExecutorStrategy;

    public FormExecutorDefault(FormExecutorStrategy<M> formExecutorStrategy) {
        this.model = formExecutorStrategy.getModel();
        this.settings = this.getSettings();
        this.formExecutorStrategy = formExecutorStrategy;
    }

    protected WicketViewerSettings getSettings() {
        GuiceBeanProvider guiceBeanProvider = (GuiceBeanProvider)this.getServicesInjector().lookupServiceElseFail(GuiceBeanProvider.class);
        return (WicketViewerSettings)guiceBeanProvider.lookup(WicketViewerSettings.class);
    }

    public boolean executeAndProcessResults(Page page, AjaxRequestTarget targetIfAny, Form<?> feedbackFormIfAny, boolean withinPrompt) {
        Command command = null;
        ObjectAdapter targetAdapter = null;
        EntityModel targetEntityModel = ((ParentEntityModelProvider)this.model).getParentEntityModel();
        try {
            targetAdapter = this.obtainTargetAdapter();
            String invalidReasonIfAny = this.getReasonInvalidIfAny();
            if (invalidReasonIfAny != null) {
                this.raiseWarning(targetIfAny, feedbackFormIfAny, invalidReasonIfAny);
                return false;
            }
            CommandContext commandContext = this.getServicesInjector().lookupService(CommandContext.class).orElse(null);
            if (commandContext != null) {
                command = commandContext.getCommand();
                command.internal().setExecutor(Command.Executor.USER);
            }
            ObjectAdapter resultAdapter = this.obtainResultAdapter();
            this.getPersistenceSession().getTransactionManager().flushTransaction();
            this.getPersistenceSession().getPersistenceManager().flush();
            targetEntityModel.resetVersion();
            targetAdapter = targetEntityModel.load();
            if (!targetAdapter.isDestroyed()) {
                targetEntityModel.resetPropertyModels();
            }
            this.onExecuteAndProcessResults(targetIfAny);
            M model = this.model;
            RedirectFacet redirectFacet = null;
            if (model instanceof ActionModel) {
                ActionModel actionModel = (ActionModel)model;
                redirectFacet = (RedirectFacet)actionModel.getActionMemento().getAction(this.getSpecificationLoader()).getFacet(RedirectFacet.class);
            }
            if (this.shouldRedirect(targetAdapter, resultAdapter, redirectFacet) || this.hasBlobsOrClobs(page) || targetIfAny == null) {
                this.redirectTo(resultAdapter, targetIfAny);
            } else {
                if (resultAdapter != null && targetAdapter != resultAdapter) {
                    targetEntityModel.setObject(resultAdapter);
                    targetAdapter = targetEntityModel.load();
                }
                if (!targetAdapter.isDestroyed()) {
                    targetEntityModel.resetPropertyModels();
                }
                this.addComponentsToRedraw(targetIfAny);
                String jGrowlCalls = JGrowlUtil.asJGrowlCalls(this.getAuthenticationSession().getMessageBroker());
                targetIfAny.appendJavaScript((CharSequence)jGrowlCalls);
            }
            return true;
        }
        catch (ConcurrencyException ex) {
            if (targetAdapter == null) {
                targetAdapter = this.obtainTargetAdapter();
            }
            this.forwardOnConcurrencyException(targetAdapter, ex);
            MessageService messageService = (MessageService)this.getServicesInjector().lookupServiceElseFail(MessageService.class);
            messageService.warnUser(ex.getMessage());
            return false;
        }
        catch (RuntimeException ex) {
            RecoverableException appEx = RecoverableException.Util.getRecoverableExceptionIfAny((Exception)ex);
            String message = null;
            if (appEx != null) {
                message = appEx.getMessage();
            }
            if (message == null) {
                message = this.recognizeException(ex, targetIfAny, feedbackFormIfAny);
            }
            if (message != null && !withinPrompt) {
                MessageBroker messageBroker = this.getAuthenticationSession().getMessageBroker();
                messageBroker.setApplicationError(message);
            }
            if (command != null) {
                command.internal().setException(Throwables.getStackTraceAsString((Throwable)ex));
            }
            throw ex;
        }
    }

    private boolean shouldRedirect(ObjectAdapter targetAdapter, ObjectAdapter resultAdapter, RedirectFacet redirectFacet) {
        if (redirectFacet == null) {
            return this.getSettings().isRedirectEvenIfSameObject();
        }
        switch (redirectFacet.policy()) {
            default: {
                return true;
            }
            case AS_CONFIGURED: {
                boolean redirectEvenIfSameObject = this.getSettings().isRedirectEvenIfSameObject();
                if (!redirectEvenIfSameObject) break;
                return true;
            }
            case ONLY_IF_DIFFERS: 
        }
        return FormExecutorDefault.differs(targetAdapter, resultAdapter);
    }

    private static boolean differs(ObjectAdapter targetAdapter, ObjectAdapter resultAdapter) {
        ObjectAdapterMemento targetOam = ObjectAdapterMemento.createOrNull((ObjectAdapter)targetAdapter);
        ObjectAdapterMemento resultOam = ObjectAdapterMemento.createOrNull((ObjectAdapter)resultAdapter);
        return FormExecutorDefault.differs(targetOam, resultOam);
    }

    private static boolean differs(ObjectAdapterMemento targetOam, ObjectAdapterMemento resultOam) {
        Bookmark resultBookmark = resultOam != null ? resultOam.asHintingBookmark() : null;
        Bookmark targetBookmark = targetOam != null ? targetOam.asHintingBookmark() : null;
        return FormExecutorDefault.differs(targetBookmark, resultBookmark);
    }

    private static boolean differs(Bookmark targetBookmark, Bookmark resultBookmark) {
        String targetBookmarkStr;
        if (resultBookmark == null && targetBookmark == null) {
            return true;
        }
        if (resultBookmark == null || targetBookmark == null) {
            return true;
        }
        String resultBookmarkStr = FormExecutorDefault.asStr(resultBookmark);
        return !Objects.equals(resultBookmarkStr, targetBookmarkStr = FormExecutorDefault.asStr(targetBookmark));
    }

    private boolean hasBlobsOrClobs(Page page) {
        Object hasBlobsOrClobs = page.visitChildren(IsisBlobOrClobPanelAbstract.class, (IVisitor)new IVisitor<IsisBlobOrClobPanelAbstract, Object>(){

            public void component(IsisBlobOrClobPanelAbstract object, IVisit<Object> visit) {
                if (!this.isUnchanging(object)) {
                    visit.stop((Object)true);
                }
            }

            private boolean isUnchanging(IsisBlobOrClobPanelAbstract object) {
                ScalarModel scalarModel = (ScalarModel)object.getModel();
                UnchangingFacet unchangingFacet = (UnchangingFacet)scalarModel.getFacet(UnchangingFacet.class);
                return unchangingFacet != null && (Boolean)unchangingFacet.value() != false;
            }
        });
        return hasBlobsOrClobs != null;
    }

    private static String asStr(Bookmark bookmark) {
        return bookmark instanceof HintStore.BookmarkWithHintId ? ((HintStore.BookmarkWithHintId)bookmark).toStringUsingHintId() : bookmark.toString();
    }

    private void forwardOnConcurrencyException(final ObjectAdapter targetAdapter, final ConcurrencyException ex) {
        EntityPage entityPage = (EntityPage)((Object)ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Callable)new Callable<EntityPage>(){

            @Override
            public EntityPage call() throws Exception {
                return new EntityPage(targetAdapter, ex);
            }
        }));
        this.getIsisSessionFactory().getCurrentSession().getPersistenceSession().getTransactionManager().flushTransaction();
        RequestCycle requestCycle = RequestCycle.get();
        requestCycle.setResponsePage((IRequestablePage)entityPage);
    }

    private void addComponentsToRedraw(AjaxRequestTarget target) {
        final ArrayList componentsToRedraw = _Lists.newArrayList();
        final ArrayList componentsNotToRedraw = _Lists.newArrayList();
        Page page = target.getPage();
        page.visitChildren((IVisitor)new IVisitor<Component, Object>(){

            public void component(Component component, IVisit<Object> visit) {
                if (component.getOutputMarkupId() && !(component instanceof Page)) {
                    List listToAddTo = this.shouldRedraw(component) ? componentsToRedraw : componentsNotToRedraw;
                    listToAddTo.add(component);
                }
            }

            private boolean shouldRedraw(Component component) {
                IModel defaultModel = component.getDefaultModel();
                if (!(defaultModel instanceof ScalarModel)) {
                    return true;
                }
                ScalarModel scalarModel = (ScalarModel)defaultModel;
                UnchangingFacet unchangingFacet = (UnchangingFacet)scalarModel.getFacet(UnchangingFacet.class);
                return unchangingFacet == null || (Boolean)unchangingFacet.value() == false;
            }
        });
        for (Component componentNotToRedraw : componentsNotToRedraw) {
            for (MarkupContainer parent = componentNotToRedraw.getParent(); parent != null; parent = parent.getParent()) {
            }
            componentNotToRedraw.visitParents(MarkupContainer.class, (IVisitor)new IVisitor<MarkupContainer, Object>(){

                public void component(MarkupContainer parent, IVisit<Object> visit) {
                    componentsToRedraw.remove(parent);
                }
            });
            if (!(componentNotToRedraw instanceof MarkupContainer)) continue;
            MarkupContainer containerNotToRedraw = (MarkupContainer)componentNotToRedraw;
            containerNotToRedraw.visitChildren((IVisitor)new IVisitor<Component, Object>(){

                public void component(Component parent, IVisit<Object> visit) {
                    componentsToRedraw.remove(parent);
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            this.debug(componentsToRedraw, (List<Component>)componentsNotToRedraw);
        }
        for (Component component : componentsToRedraw) {
            target.add(new Component[]{component});
        }
    }

    private void debug(List<Component> componentsToRedraw, List<Component> componentsNotToRedraw) {
        this.debug("Not redrawing", componentsNotToRedraw);
        this.debug("Redrawing", componentsToRedraw);
    }

    private void debug(String title, List<Component> list) {
        LOG.debug(">>> {}:", (Object)title);
        for (Component component : list) {
            LOG.debug(String.format("%30s: %s", component.getClass().getSimpleName(), component.getPath()));
        }
    }

    private String recognizeException(RuntimeException ex, AjaxRequestTarget target, Form<?> feedbackForm) {
        Stream exceptionRecognizers = this.getServicesInjector().streamServices(ExceptionRecognizer.class);
        String recognizedErrorIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
        if (recognizedErrorIfAny != null) {
            this.raiseWarning(target, feedbackForm, recognizedErrorIfAny);
            this.getTransactionManager().getCurrentTransaction().clearAbortCause();
        }
        return recognizedErrorIfAny;
    }

    private void raiseWarning(AjaxRequestTarget targetIfAny, Form<?> feedbackFormIfAny, String error) {
        if (targetIfAny != null && feedbackFormIfAny != null) {
            targetIfAny.add(new Component[]{feedbackFormIfAny});
            feedbackFormIfAny.error((Serializable)((Object)error));
        } else {
            MessageService messageService = (MessageService)this.getServicesInjector().lookupServiceElseFail(MessageService.class);
            messageService.warnUser(error);
        }
    }

    protected IsisSession getCurrentSession() {
        return this.getIsisSessionFactory().getCurrentSession();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getCurrentSession().getPersistenceSession();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getCurrentSession().getAuthenticationSession();
    }

    private ObjectAdapter obtainTargetAdapter() {
        return this.formExecutorStrategy.obtainTargetAdapter();
    }

    private String getReasonInvalidIfAny() {
        return this.formExecutorStrategy.getReasonInvalidIfAny();
    }

    private void onExecuteAndProcessResults(AjaxRequestTarget target) {
        this.formExecutorStrategy.onExecuteAndProcessResults(target);
    }

    private ObjectAdapter obtainResultAdapter() {
        return this.formExecutorStrategy.obtainResultAdapter();
    }

    private void redirectTo(ObjectAdapter resultAdapter, AjaxRequestTarget target) {
        this.formExecutorStrategy.redirectTo(resultAdapter, target);
    }
}

