/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import javax.inject.Inject;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.authroles.authentication.panel.SignInPanel;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

public class IsisSignInPanel
extends SignInPanel {
    private static final long serialVersionUID = 1L;
    private final boolean signUpLink;
    private final boolean passwordResetLink;
    private final boolean clearOriginalDestination;
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    ServicesInjector servicesInjector;
    @Inject
    private PageClassRegistry pageClassRegistry;
    @Inject
    private EmailNotificationService emailNotificationService;
    @Inject
    private EmailService emailService;

    public IsisSignInPanel(String id, boolean rememberMe, boolean signUpLink, boolean passwordResetLink, boolean continueToOriginalDestination) {
        super(id, rememberMe);
        this.signUpLink = signUpLink;
        this.passwordResetLink = passwordResetLink;
        this.clearOriginalDestination = !continueToOriginalDestination;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addOrReplace(new Component[]{new NotificationPanel("feedback")});
        BookmarkablePageLink<Void> passwordResetLink = this.addPasswordResetLink();
        BookmarkablePageLink<Void> signUpLink = this.addSignUpLink();
        this.setVisibilityAllowedBasedOnAvailableServices(new Component[]{signUpLink, passwordResetLink});
    }

    private BookmarkablePageLink<Void> addPasswordResetLink() {
        return this.addLink("passwdResetLink", PageType.PASSWORD_RESET, this.passwordResetLink);
    }

    private BookmarkablePageLink<Void> addSignUpLink() {
        return this.addLink("signUpLink", PageType.SIGN_UP, this.signUpLink);
    }

    private BookmarkablePageLink<Void> addLink(String id, PageType pageType, boolean visibilityAllowed) {
        BookmarkablePageLink link;
        if (this.pageClassRegistry != null) {
            Class<? extends Page> signUpPageClass = this.pageClassRegistry.getPageClass(pageType);
            link = new BookmarkablePageLink(id, signUpPageClass);
            if (!visibilityAllowed) {
                link.setVisibilityAllowed(false);
            }
        } else {
            link = new BookmarkablePageLink(id, null);
            link.setVisibilityAllowed(false);
        }
        this.getSignInForm().addOrReplace(new Component[]{link});
        return link;
    }

    private void setVisibilityAllowedBasedOnAvailableServices(Component ... components) {
        UserRegistrationService userRegistrationService = this.servicesInjector.lookupService(UserRegistrationService.class).orElse(null);
        EmailNotificationService emailNotificationService1 = this.servicesInjector.lookupService(EmailNotificationService.class).orElse(null);
        boolean visibilityAllowed = userRegistrationService != null && emailNotificationService1.isConfigured();
        for (Component component : components) {
            if (!component.isVisibilityAllowed()) continue;
            component.setVisibilityAllowed(visibilityAllowed);
        }
    }

    private MarkupContainer getSignInForm() {
        return (MarkupContainer)this.get("signInForm");
    }

    protected void onSignInSucceeded() {
        if (this.clearOriginalDestination) {
            this.clearOriginalDestination();
        }
        super.onSignInSucceeded();
    }

    protected void onSignInRemembered() {
        if (this.clearOriginalDestination) {
            this.clearOriginalDestination();
        }
        super.onSignInRemembered();
    }
}

