/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.entity;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.whereami.WhereAmIModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class EntityPage
extends PageAbstract {
    private static final long serialVersionUID = 144368606134796079L;
    private static final CssResourceReference WHERE_AM_I_CSS = new CssResourceReference(EntityPage.class, "EntityPage.css");
    private final EntityModel model;
    private final String titleString;

    public EntityPage(PageParameters pageParameters) {
        this(pageParameters, EntityPage.createEntityModel(pageParameters));
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)WHERE_AM_I_CSS));
    }

    private static EntityModel createEntityModel(PageParameters parameters) {
        String oid = EntityModel.oidStr((PageParameters)parameters);
        if (Strings.isEmpty((CharSequence)oid)) {
            throw new RestartResponseException(Application.get().getHomePage());
        }
        return new EntityModel(parameters);
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel) {
        this(pageParameters, entityModel, null);
    }

    public EntityPage(ObjectAdapter adapter) {
        this(adapter, null);
    }

    public EntityPage(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        this(PageParametersUtils.newPageParameters(), EntityPage.newEntityModel(adapter, exIfAny));
    }

    private static EntityModel newEntityModel(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        EntityModel model = new EntityModel(adapter);
        model.setException(exIfAny);
        return model;
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel, String titleString) {
        super(pageParameters, titleString, ComponentType.ENTITY);
        this.model = entityModel;
        this.titleString = titleString;
        this.buildPage();
    }

    private void addBreadcrumbIfShown(EntityModel entityModel) {
        if (!this.isShowBreadcrumbs()) {
            return;
        }
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.visited(entityModel);
    }

    private void removeAnyBreadcrumb(EntityModel entityModel) {
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.remove(entityModel);
    }

    @Override
    public UiHintContainer getUiHintContainerIfAny() {
        return this.model;
    }

    private void buildPage() {
        ObjectAdapter objectAdapter;
        try {
            objectAdapter = (ObjectAdapter)this.model.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw new ObjectMember.AuthorizationException(ex);
        }
        if (!ObjectAdapter.Util.isVisible((ObjectAdapter)objectAdapter, (InteractionInitiatedBy)InteractionInitiatedBy.USER)) {
            throw new ObjectMember.AuthorizationException();
        }
        ObjectSpecification objectSpec = this.model.getTypeOfSpecification();
        GridFacet gridFacet = (GridFacet)objectSpec.getFacet(GridFacet.class);
        if (gridFacet != null) {
            gridFacet.getGrid((ManagedObject)objectAdapter);
        }
        if (this.titleString == null) {
            String titleStr = objectAdapter.titleString(null);
            this.setTitle(titleStr);
        }
        WebMarkupContainer entityPageContainer = new WebMarkupContainer("entityPageContainer");
        CssClassAppender.appendCssClassTo((MarkupContainer)entityPageContainer, CssClassAppender.asCssStyle("isis-" + objectSpec.getSpecId().asString().replace(".", "-")));
        CssClassFacet cssClassFacet = (CssClassFacet)objectSpec.getFacet(CssClassFacet.class);
        if (cssClassFacet != null) {
            String cssClass = cssClassFacet.cssClass((ManagedObject)objectAdapter);
            CssClassAppender.appendCssClassTo((MarkupContainer)entityPageContainer, cssClass);
        }
        this.themeDiv.addOrReplace(new Component[]{entityPageContainer});
        this.addWhereAmIIfShown(entityPageContainer, WhereAmIModel.of((EntityModel)this.model));
        this.addChildComponents((MarkupContainer)entityPageContainer, (IModel<?>)this.model);
        this.bookmarkPageIfShown((BookmarkableModel<?>)this.model);
        this.addBreadcrumbIfShown(this.model);
        this.addBookmarkedPages((MarkupContainer)entityPageContainer);
    }

    protected void addWhereAmIIfShown(WebMarkupContainer entityPageContainer, WhereAmIModel whereAmIModel) {
        WebMarkupContainer whereAmIContainer = new WebMarkupContainer("whereAmI-container");
        entityPageContainer.addOrReplace(new Component[]{whereAmIContainer});
        if (!whereAmIModel.isShowWhereAmI()) {
            whereAmIContainer.setVisible(false);
            return;
        }
        RepeatingView listItems = new RepeatingView("whereAmI-items");
        whereAmIModel.streamParentChainReversed().forEach(entityModel -> listItems.add(new Component[]{new EntityIconAndTitlePanel(listItems.newChildId(), (ObjectAdapterModel)entityModel)}));
        listItems.add(new Component[]{new Label(listItems.newChildId(), (Serializable)((Object)whereAmIModel.getStartOfChain().getTitle()))});
        whereAmIContainer.addOrReplace(new Component[]{listItems});
    }
}

