/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.MessageBroker;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class JGrowlBehaviour
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;

    protected void respond(AjaxRequestTarget target) {
        String feedbackMsg = JGrowlUtil.asJGrowlCalls(this.getMessageBroker());
        if (!_Strings.isNullOrEmpty((CharSequence)feedbackMsg)) {
            target.appendJavaScript((CharSequence)feedbackMsg);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.renderFeedbackMessages(response);
    }

    public void renderFeedbackMessages(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(JGrowlBehaviour.class, "js/bootstrap-growl.js")));
        String feedbackMsg = JGrowlUtil.asJGrowlCalls(this.getMessageBroker());
        if (!_Strings.isNullOrEmpty((CharSequence)feedbackMsg)) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)feedbackMsg));
        }
    }

    protected MessageBroker getMessageBroker() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession().getMessageBroker();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

