/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.applib.services.error.Ticket;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.StackTraceListView;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.home.HomePage;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class ExceptionStackTracePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_MAIN_MESSAGE = "mainMessage";
    private static final String ID_EXCEPTION_DETAIL_DIV = "exceptionDetailDiv";
    private static final String ID_TICKET_MARKUP = "ticketMarkup";
    private static final String ID_STACK_TRACE_ELEMENT = "stackTraceElement";
    private static final String ID_LINE = "stackTraceElementLine";
    private static final JavaScriptResourceReference DIV_TOGGLE_JS = new JavaScriptResourceReference(ExceptionStackTracePanel.class, "div-toggle.js");
    @Inject
    PageClassRegistry pageClassRegistry;

    public ExceptionStackTracePanel(String id, ExceptionModel exceptionModel) {
        super(id, (IModel)exceptionModel);
        PageParameters pageParameters;
        Class<HomePage> pageClass;
        boolean suppressExceptionDetail;
        String ticketMarkup;
        Ticket ticket = exceptionModel.getTicket();
        String mainMessage = ticket != null && ticket.getUserMessage() != null ? ticket.getUserMessage() : exceptionModel.getMainMessage();
        Label label = new Label(ID_MAIN_MESSAGE, (Serializable)((Object)mainMessage));
        this.add(new Component[]{label});
        String string = ticketMarkup = ticket != null ? ticket.getMarkup() : null;
        if (ticketMarkup == null) {
            Components.permanentlyHide((MarkupContainer)this, ID_TICKET_MARKUP);
        } else {
            this.add(new Component[]{new MarkupComponent(ID_TICKET_MARKUP, (IModel<?>)Model.of((Serializable)((Object)ticket.getMarkup())))});
        }
        boolean bl = suppressExceptionDetail = exceptionModel.isAuthorizationException() || exceptionModel.isRecognized() || ticket != null && ticket.getStackTracePolicy() == Ticket.StackTracePolicy.HIDE;
        if (suppressExceptionDetail) {
            Components.permanentlyHide((MarkupContainer)this, ID_EXCEPTION_DETAIL_DIV);
        } else {
            WebMarkupContainer container = new WebMarkupContainer(ID_EXCEPTION_DETAIL_DIV){
                private static final long serialVersionUID = 1L;

                public void renderHead(IHeaderResponse response) {
                    response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)DIV_TOGGLE_JS));
                }
            };
            container.add(new Component[]{new StackTraceListView(ID_STACK_TRACE_ELEMENT, ID_LINE, exceptionModel.getStackTrace())});
            this.add(new Component[]{container});
        }
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        EntityModel entityModel = breadcrumbModel.getMostRecentlyVisited();
        if (entityModel != null) {
            pageClass = this.pageClassRegistry.getPageClass(PageType.ENTITY);
            pageParameters = entityModel.getPageParameters();
        } else {
            pageParameters = null;
            pageClass = HomePage.class;
        }
        AbstractLink link = Links.newBookmarkablePageLink("continueButton", pageParameters, pageClass);
        this.add(new Component[]{link});
    }

    public class ExternalImageUrl
    extends WebComponent {
        private static final long serialVersionUID = -3556235292216447710L;

        public ExternalImageUrl(String id, String imageUrl) {
            super(id);
            this.add(new Behavior[]{new AttributeModifier("src", (IModel)new Model((Serializable)((Object)imageUrl)))});
            this.setVisible(imageUrl != null && !imageUrl.equals(""));
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            this.checkComponentTag(tag, "img");
        }
    }
}

