/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.themepicker;

import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.util.List;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.IsisWicketThemeSupportDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IsisWicketThemeSupport {
    public static final String ENABLED_THEMES_KEY = "isis.viewer.wicket.themes.enabled";
    public static final String DEFAULT_THEME_KEY = "isis.viewer.wicket.themes.initial";
    public static final String THEME_SUPPORT_PROVIDER_KEY = "isis.viewer.wicket.themes.provider";
    public static final Class<? extends IsisWicketThemeSupport> THEME_SUPPORT_DEFAULT_CLASS = IsisWicketThemeSupportDefault.class;

    public ThemeProvider getThemeProvider();

    public List<String> getEnabledThemeNames();

    public static IsisWicketThemeSupport getInstance() {
        return (IsisWicketThemeSupport)_Context.computeIfAbsent(IsisWicketThemeSupport.class, __ -> IsisWicketThemeSupport.createInstance());
    }

    public static IsisWicketThemeSupport createInstance() {
        IsisConfiguration configuration = IsisContext.getConfiguration();
        String themeSupportClassName = configuration.getString(THEME_SUPPORT_PROVIDER_KEY, THEME_SUPPORT_DEFAULT_CLASS.getName());
        try {
            IsisWicketThemeSupport themeSupport = (IsisWicketThemeSupport)InstanceUtil.createInstance((String)themeSupportClassName, (Object[])new Object[0]);
            return themeSupport;
        }
        catch (Exception e) {
            Logger LOG = LoggerFactory.getLogger(IsisWicketThemeSupport.class);
            LOG.warn("Could not instantiate configured theme support class '{}', defaulting to '{}'", (Object)themeSupportClassName, (Object)THEME_SUPPORT_DEFAULT_CLASS.getName());
            return (IsisWicketThemeSupport)InstanceUtil.createInstance(THEME_SUPPORT_DEFAULT_CLASS, (Object[])new Object[0]);
        }
    }
}

