/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;

public class ObjectAdapterMementoProviderForReferenceObjectAutoComplete
extends ObjectAdapterMementoProviderAbstract {
    private static final long serialVersionUID = 1L;

    public ObjectAdapterMementoProviderForReferenceObjectAutoComplete(ScalarModel model, WicketViewerSettings wicketViewerSettings) {
        super(model, wicketViewerSettings);
    }

    @Override
    protected List<ObjectAdapterMemento> obtainMementos(String term) {
        ObjectSpecification typeOfSpecification = this.getScalarModel().getTypeOfSpecification();
        AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
        List autoCompleteAdapters = autoCompleteFacet.execute(term, InteractionInitiatedBy.USER);
        return _Lists.map((Collection)autoCompleteAdapters, (Function)ObjectAdapterMemento.Functions.fromAdapter());
    }

    public Collection<ObjectAdapterMemento> toChoices(Collection<String> ids) {
        Function<String, ObjectAdapterMemento> function = input -> {
            if ("$$_isis_null_$$".equals(input)) {
                return null;
            }
            RootOid oid = RootOid.deString((String)input);
            ObjectAdapterMemento oam = ObjectAdapterMemento.createPersistent((RootOid)oid);
            return oam;
        };
        return _NullSafe.stream(ids).map(function).collect(Collectors.toList());
    }
}

