/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.IsisConverterLocator;
import org.apache.wicket.Session;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public abstract class ObjectAdapterMementoProviderAbstract
extends ChoiceProvider<ObjectAdapterMemento> {
    private static final long serialVersionUID = 1L;
    protected static final String NULL_PLACEHOLDER = "$$_isis_null_$$";
    private static final String NULL_DISPLAY_TEXT = "";
    private final ScalarModel scalarModel;
    private final WicketViewerSettings wicketViewerSettings;

    public ObjectAdapterMementoProviderAbstract(ScalarModel scalarModel, WicketViewerSettings wicketViewerSettings) {
        this.scalarModel = scalarModel;
        this.wicketViewerSettings = wicketViewerSettings;
    }

    public String getDisplayValue(ObjectAdapterMemento choice) {
        if (choice == null) {
            return NULL_DISPLAY_TEXT;
        }
        ObjectAdapter objectAdapter = choice.getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
        IConverter<Object> converter = this.findConverter(objectAdapter);
        return converter != null ? converter.convertToString(objectAdapter.getPojo(), this.getLocale()) : objectAdapter.titleString(null);
    }

    protected Locale getLocale() {
        return Session.exists() ? Session.get().getLocale() : Locale.ENGLISH;
    }

    protected IConverter<Object> findConverter(ObjectAdapter objectAdapter) {
        return IsisConverterLocator.findConverter(objectAdapter, this.wicketViewerSettings);
    }

    public String getIdValue(ObjectAdapterMemento choice) {
        return choice != null ? choice.asString() : NULL_PLACEHOLDER;
    }

    public void query(String term, int page, Response<ObjectAdapterMemento> response) {
        ArrayList mementos = _Lists.newArrayList(this.obtainMementos(term));
        if (!this.scalarModel.isRequired() && !mementos.contains(null)) {
            mementos.add(0, null);
        }
        response.addAll((Collection)mementos);
    }

    protected abstract List<ObjectAdapterMemento> obtainMementos(String var1);

    protected final List<ObjectAdapterMemento> obtainMementos(String term, Collection<ObjectAdapterMemento> choicesMementos) {
        ArrayList matches = _Lists.newArrayList();
        if (Strings.isEmpty((CharSequence)term)) {
            matches.addAll(choicesMementos);
        } else {
            for (ObjectAdapterMemento candidate : choicesMementos) {
                ObjectAdapter objectAdapter = candidate.getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
                String title = objectAdapter.titleString(objectAdapter);
                if (!title.toLowerCase().contains(term.toLowerCase())) continue;
                matches.add(candidate);
            }
        }
        return matches;
    }

    protected ScalarModel getScalarModel() {
        return this.scalarModel;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }
}

