/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.net.URL;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettingsAccessor;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.AjaxDeferredBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxIndicatorAppender;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.time.Duration;

public abstract class ActionLink
extends AjaxLink<ObjectAdapter>
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    private final AjaxIndicatorAppender indicatorAppenderIfAny;
    final AjaxDeferredBehaviour ajaxDeferredBehaviourIfAny;
    private transient ObjectAction objectAction;

    public ActionLink(String id, ActionModel model) {
        this(id, model, null);
    }

    ActionLink(String id, ActionModel model, ObjectAction action) {
        super(id, (IModel)model);
        boolean useIndicatorForNoArgAction = this.getSettings().isUseIndicatorForNoArgAction();
        AjaxIndicatorAppender ajaxIndicatorAppender = this.indicatorAppenderIfAny = useIndicatorForNoArgAction ? new AjaxIndicatorAppender() : null;
        if (this.indicatorAppenderIfAny != null) {
            this.add(new Behavior[]{this.indicatorAppenderIfAny});
        }
        this.objectAction = action;
        this.ajaxDeferredBehaviourIfAny = this.determineDeferredBehaviour();
        if (this.ajaxDeferredBehaviourIfAny != null) {
            this.add(new Behavior[]{this.ajaxDeferredBehaviourIfAny});
        }
    }

    public void onClick(AjaxRequestTarget target) {
        if (this.ajaxDeferredBehaviourIfAny != null) {
            this.ajaxDeferredBehaviourIfAny.initiate(target);
            return;
        }
        this.doOnClick(target);
    }

    protected abstract void doOnClick(AjaxRequestTarget var1);

    ActionModel getActionModel() {
        return (ActionModel)this.getModel();
    }

    public ObjectAction getObjectAction() {
        return this.objectAction != null ? this.objectAction : (this.objectAction = this.getActionModel().getActionMemento().getAction(this.getSpecificationLoader()));
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.getSettings().isPreventDoubleClickForNoArgAction()) {
            PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
        }
        attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
    }

    public String getReasonDisabledIfAny() {
        return this.isVisible() ? this.getActionModel().getReasonDisabledIfAny() : null;
    }

    protected void onConfigure() {
        super.onConfigure();
    }

    public boolean isVisible() {
        return this.determineIfVisible();
    }

    private boolean determineIfVisible() {
        return this.getActionModel().isVisible();
    }

    @Programmatic
    public boolean isEnabled() {
        return this.determineIfEnabled();
    }

    private boolean determineIfEnabled() {
        try {
            String reasonDisabledIfAny = this.getReasonDisabledIfAny();
            return reasonDisabledIfAny == null;
        }
        catch (ConcurrencyException ex) {
            IsisContext.getSessionFactory().getCurrentSession().getAuthenticationSession().getMessageBroker().addMessage(ex.getMessage());
            throw new RestartResponseException((IRequestablePage)new EntityPage(this.getActionModel().getTargetAdapter()));
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
    }

    public String getAjaxIndicatorMarkupId() {
        return this.indicatorAppenderIfAny != null ? this.indicatorAppenderIfAny.getMarkupId() : null;
    }

    protected WicketViewerSettings getSettings() {
        return ((WicketViewerSettingsAccessor)Application.get()).getSettings();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSessionFactory().getSpecificationLoader();
    }

    AjaxDeferredBehaviour determineDeferredBehaviour() {
        ObjectAction action = this.getObjectAction();
        final ActionModel actionModel = this.getActionModel();
        if (ActionLink.isNoArgReturnTypeRedirect(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.NEW_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = actionModel.execute();
                    Object value = resultAdapter.getPojo();
                    return ActionModel.redirectHandler((Object)value);
                }
            };
        }
        if (ActionLink.isNoArgReturnTypeDownload(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.SAME_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = actionModel.execute();
                    Object value = resultAdapter != null ? resultAdapter.getPojo() : null;
                    IRequestHandler handler = ActionModel.downloadHandler((Object)value);
                    return ActionLink.isIdempotentOrCachable(actionModel) ? handler : ActionLink.enforceNoCacheOnClientSide(handler);
                }
            };
        }
        return null;
    }

    private static boolean isNoArgReturnTypeRedirect(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && (action.getReturnType().getCorrespondingClass() == URL.class || action.getReturnType().getCorrespondingClass() == LocalResourcePath.class);
    }

    private static boolean isNoArgReturnTypeDownload(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && (action.getReturnType().getCorrespondingClass() == Blob.class || action.getReturnType().getCorrespondingClass() == Clob.class);
    }

    private static boolean isIdempotentOrCachable(ActionModel actionModel) {
        ObjectAction objectAction = actionModel.getActionMemento().getAction(actionModel.getSpecificationLoader());
        return ObjectAction.Util.isIdempotentOrCachable((ObjectAction)objectAction);
    }

    private static IRequestHandler enforceNoCacheOnClientSide(IRequestHandler downloadHandler) {
        if (downloadHandler == null) {
            return downloadHandler;
        }
        if (downloadHandler instanceof ResourceStreamRequestHandler) {
            ((ResourceStreamRequestHandler)downloadHandler).setCacheDuration(Duration.seconds((int)0));
        }
        return downloadHandler;
    }
}

