/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap;

import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public class FormGroup
extends WebMarkupContainer {
    private final FormComponent<?> formComponent;

    public FormGroup(String id, FormComponent<?> formComponent) {
        super(id);
        this.formComponent = (FormComponent)Args.notNull(formComponent, (String)"formComponent");
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"form-group"});
        this.applyFeedbackClasses(tag, this.formComponent);
    }

    protected void applyFeedbackClasses(ComponentTag tag, FormComponent<?> formComponent) {
        FeedbackMessages feedbackMessages = formComponent.getFeedbackMessages();
        for (FeedbackMessage feedbackMessage : feedbackMessages) {
            if (feedbackMessage.getLevel() == 400) {
                Attributes.addClass((ComponentTag)tag, (String[])new String[]{"has-error"});
                continue;
            }
            if (feedbackMessage.getLevel() == 300) {
                Attributes.addClass((ComponentTag)tag, (String[])new String[]{"has-warning"});
                continue;
            }
            if (feedbackMessage.getLevel() != 250) continue;
            Attributes.addClass((ComponentTag)tag, (String[])new String[]{"has-success"});
        }
    }
}

