/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.uuid;

import java.util.Locale;
import java.util.UUID;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

public class UuidConverter
implements IConverter<UUID> {
    private static final long serialVersionUID = 1L;

    public UUID convertToObject(String value, Locale locale) throws ConversionException {
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw this.newConversionException(value);
        }
    }

    public String convertToString(UUID value, Locale locale) {
        return value != null ? value.toString() : null;
    }

    private ConversionException newConversionException(String value) {
        return new ConversionException(String.format("Failed to convert '%s' to a UUID", value));
    }
}

