/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.string;

import java.io.Serializable;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldParseableAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldStringModel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;

public class MultiLineStringPanel
extends ScalarPanelTextFieldParseableAbstract {
    private static final long serialVersionUID = 1L;

    public MultiLineStringPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected AbstractTextComponent<String> createTextFieldForRegular(String id) {
        TextFieldStringModel model = new TextFieldStringModel(this);
        TextArea textArea = new TextArea(id, (IModel)model);
        this.setRowsAndMaxLengthAttributesOn((TextArea<String>)textArea);
        return textArea;
    }

    private void setRowsAndMaxLengthAttributesOn(TextArea<String> textField) {
        MultiLineFacet multiLineFacet = (MultiLineFacet)((ScalarModel)this.getModel()).getFacet(MultiLineFacet.class);
        this.setAttribute(textField, "rows", multiLineFacet.numberOfLines());
        Integer maxLength = MultiLineStringPanel.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class);
        if (maxLength != null) {
            this.setAttribute(textField, "maxlength", maxLength);
        }
    }

    @Override
    protected String createTextFieldFragmentId() {
        return "textarea";
    }

    @Override
    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        Fragment fragment = new Fragment(id, "textareaInlinePrompt", (MarkupContainer)this);
        TextArea<String> inlinePromptTextArea = new TextArea<String>("scalarValue", inlinePromptModel){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
        this.setRowsAndMaxLengthAttributesOn(inlinePromptTextArea);
        fragment.add(new Component[]{inlinePromptTextArea});
        return fragment;
    }

    @Override
    protected String obtainInlinePromptLinkCssIfAny() {
        return null;
    }

    @Override
    protected String getScalarPanelType() {
        return "multiLineStringPanel";
    }

    private Component setAttribute(TextArea<String> textField, String attributeName, int i) {
        return textField.add(new Behavior[]{AttributeModifier.replace((String)attributeName, (Serializable)((Object)("" + i)))});
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }
}

