/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;

public class DateFormatSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String datePattern;
    private final String dateTimePattern;
    private final int adjustBy;

    public static DateFormatSettings of(String datePattern, String dateTimePattern, int adjustBy) {
        return new DateFormatSettings(datePattern, dateTimePattern, adjustBy);
    }

    public static DateFormatSettings of(String datePattern, String dateTimePattern) {
        return DateFormatSettings.of(datePattern, dateTimePattern, 0);
    }

    public static DateFormatSettings of(String datePattern) {
        return DateFormatSettings.of(datePattern, datePattern, 0);
    }

    public static DateFormatSettings ofDateAndTime(WicketViewerSettings settings, int adjustBy) {
        return DateFormatSettings.of(settings.getDatePattern(), settings.getDateTimePattern(), adjustBy);
    }

    public static DateFormatSettings ofDateOnly(WicketViewerSettings settings, int adjustBy) {
        return DateFormatSettings.of(settings.getDatePattern(), settings.getDatePattern(), adjustBy);
    }

    private DateFormatSettings(String datePattern, String dateTimePattern, int adjustBy) {
        this.datePattern = datePattern;
        this.dateTimePattern = dateTimePattern;
        this.adjustBy = adjustBy;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public int getAdjustBy() {
        return this.adjustBy;
    }

    public String toString() {
        return "DateFormatSettings [datePattern=" + this.datePattern + ", dateTimePattern=" + this.dateTimePattern + ", adjustBy=" + this.adjustBy + "]";
    }
}

