/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.property;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.security.authentication.MessageBroker;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;

public class PropertyEditPanel
extends PanelAbstract<ScalarModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_PROPERTY_NAME = "propertyName";
    private boolean showHeader = true;

    public PropertyEditPanel(String id, ScalarModel scalarModel) {
        super(id, new ScalarModel(scalarModel.getParentEntityModel(), scalarModel.getPropertyMemento(), EntityModel.Mode.EDIT, EntityModel.RenderingHint.REGULAR));
        this.buildGui(scalarModel);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui(this.getScalarModel());
    }

    private void buildGui(ScalarModel scalarModel) {
        this.buildGuiForParameters(scalarModel);
    }

    ScalarModel getScalarModel() {
        return (ScalarModel)super.getModel();
    }

    public PropertyEditPanel setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    private void buildGuiForParameters(ScalarModel scalarModel) {
        WebMarkupContainer header = this.addHeader();
        try {
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.getScalarModel());
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)scalarModel.getParentEntityModel());
            OneToOneAssociation property = this.getScalarModel().getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
            String propertyName = property.getName();
            Label label = new Label(ID_PROPERTY_NAME, (IModel)Model.of((Serializable)((Object)propertyName)));
            NamedFacet namedFacet = (NamedFacet)property.getFacet(NamedFacet.class);
            if (namedFacet != null) {
                label.setEscapeModelStrings(namedFacet.escaped());
            }
            header.add(new Component[]{label});
        }
        catch (ConcurrencyException ex) {
            ObjectAdapter targetAdapter = scalarModel.getParentEntityModel().load();
            EntityPage entityPage = new EntityPage(targetAdapter, null);
            this.setResponsePage((IRequestablePage)entityPage);
            this.getMessageBroker().addWarning(ex.getMessage());
        }
    }

    private WebMarkupContainer addHeader() {
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(PropertyEditPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        return header;
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }
}

