/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs.TabPanel;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabGroupPanel
extends AjaxBootstrapTabbedPanel<ITab> {
    private static final long serialVersionUID = 1L;
    public static final String SESSION_ATTR_SELECTED_TAB = "selectedTab";
    private final ComponentHintKey selectedTabHintKey;
    private final EntityModel entityModel;

    private static List<ITab> tabsFor(final EntityModel entityModel, BS3TabGroup bs3TabGroup) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        List tablist = _NullSafe.stream((Collection)bs3TabGroup.getTabs()).filter(BS3Tab.Predicates.notEmpty()).collect(Collectors.toList());
        for (final BS3Tab bs3Tab : tablist) {
            final RepeatingViewWithDynamicallyVisibleContent rv = TabPanel.newRows(entityModel, bs3Tab);
            String translateContext = entityModel.getTypeOfSpecification().getFullIdentifier();
            String bs3TabName = bs3Tab.getName();
            String tabName = TabGroupPanel.getTranslationService().translate(translateContext, bs3TabName);
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)tabName))){
                private static final long serialVersionUID = 1L;

                public Panel getPanel(String panelId) {
                    return new TabPanel(panelId, entityModel, bs3Tab, rv);
                }

                public boolean isVisible() {
                    return rv.isVisible();
                }
            });
        }
        return tabs;
    }

    static TranslationService getTranslationService() {
        return IsisContext.getSessionFactory().getServicesInjector().lookupService(TranslationService.class).orElse(null);
    }

    public TabGroupPanel(String id, EntityModel entityModel, BS3TabGroup bs3TabGroup) {
        super(id, TabGroupPanel.tabsFor(entityModel, bs3TabGroup));
        this.entityModel = entityModel;
        this.selectedTabHintKey = ComponentHintKey.create((Component)this, (String)SESSION_ATTR_SELECTED_TAB);
    }

    protected void onInitialize() {
        this.setSelectedTabFromSessionIfAny(this);
        super.onInitialize();
    }

    public TabbedPanel<ITab> setSelectedTab(int index) {
        this.selectedTabHintKey.set(this.entityModel.getObjectAdapterMemento().asHintingBookmark(), "" + index);
        return super.setSelectedTab(index);
    }

    private void setSelectedTabFromSessionIfAny(AjaxBootstrapTabbedPanel<ITab> ajaxBootstrapTabbedPanel) {
        String selectedTabStr = this.selectedTabHintKey.get(this.entityModel.getObjectAdapterMemento().asHintingBookmark());
        Integer tabIndex = this.parse(selectedTabStr);
        if (tabIndex != null) {
            int numTabs = ajaxBootstrapTabbedPanel.getTabs().size();
            if (tabIndex < numTabs) {
                ajaxBootstrapTabbedPanel.setSelectedTab(tabIndex.intValue());
            }
        }
    }

    private Integer parse(String selectedTabStr) {
        try {
            return Integer.parseInt(selectedTabStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isVisible() {
        return _NullSafe.stream((Collection)this.getTabs()).anyMatch(ITab::isVisible);
    }
}

