/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary.CollectionContentsAsSummaryFactory;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.AbstractItem;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionContentsAsSummary
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider {
    private static final String ID_MAX = "max";
    private static final String ID_MIN = "min";
    private static final String ID_AVG = "avg";
    private static final String ID_SUM = "sum";
    private static final String ID_PROPERTY_NAME = "propertyName";
    private static final String ID_REPEATING_SUMMARY = "repeatingSummary";
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";

    public CollectionContentsAsSummary(String id, EntityCollectionModel model) {
        super(id, model);
        this.buildGui();
    }

    private void buildGui() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        ObjectSpecification elementSpec = model.getTypeOfSpecification();
        NotificationPanel feedback = new NotificationPanel(ID_FEEDBACK);
        feedback.setOutputMarkupId(true);
        this.addOrReplace(new Component[]{feedback});
        Stream<ObjectAssociation> numberAssociations = elementSpec.streamAssociations(Contributed.EXCLUDED).filter(CollectionContentsAsSummaryFactory.OF_TYPE_BIGDECIMAL);
        RepeatingView repeating = new RepeatingView(ID_REPEATING_SUMMARY);
        this.addOrReplace(new Component[]{repeating});
        numberAssociations.forEach(numberAssociation -> {
            AbstractItem item = new AbstractItem(repeating.newChildId());
            repeating.add(new Component[]{item});
            String propertyName = numberAssociation.getName();
            item.add(new Component[]{new Label(ID_PROPERTY_NAME, (IModel)new Model((Serializable)((Object)propertyName)))});
            List adapters = (List)model.getObject();
            Summary summary = new Summary(propertyName, adapters, (ObjectAssociation)numberAssociation);
            this.addItem(item, ID_SUM, summary.getTotal());
            this.addItem(item, ID_AVG, summary.getAverage());
            this.addItem(item, ID_MIN, summary.getMin());
            this.addItem(item, ID_MAX, summary.getMax());
        });
    }

    private void addItem(AbstractItem item, String id, BigDecimal amt) {
        TextField textField = new TextField(id, (IModel)new Model((Serializable)((Object)this.format(amt))));
        item.add(new Component[]{textField});
    }

    private String format(BigDecimal amt) {
        return amt != null ? amt.setScale(2, RoundingMode.HALF_UP).toPlainString() : "";
    }

    protected void onModelChanged() {
        this.buildGui();
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }

    public static class Summary {
        private BigDecimal sum = BigDecimal.ZERO;
        private BigDecimal min = null;
        private BigDecimal max = null;
        private final List<String> titles = _Lists.newArrayList();
        private final List<BigDecimal> values = _Lists.newArrayList();
        private BigDecimal average;
        private String propertyName;
        private static final Function<BigDecimal, Number> BIGDECIMAL_TO_NUMBER = new Function<BigDecimal, Number>(){

            public Number apply(BigDecimal value) {
                return value;
            }
        };

        public Summary(List<ObjectAdapter> adapters, ObjectAssociation numberAssociation) {
            this(null, adapters, numberAssociation);
        }

        public Summary(String propertyName, List<ObjectAdapter> adapters, ObjectAssociation numberAssociation) {
            this.propertyName = propertyName;
            int nonNullCount = 0;
            for (ObjectAdapter objectAdapter : adapters) {
                this.titles.add(objectAdapter.titleString(null));
                ObjectAdapter valueAdapter = numberAssociation.get(objectAdapter, InteractionInitiatedBy.USER);
                if (valueAdapter == null) {
                    this.values.add(null);
                    continue;
                }
                Object valueObj = ObjectAdapter.Util.unwrapPojo((ManagedObject)valueAdapter);
                if (valueObj == null) {
                    this.values.add(null);
                    continue;
                }
                ++nonNullCount;
                BigDecimal value = (BigDecimal)valueObj;
                this.sum = this.sum.add(value);
                this.min = this.min != null && this.min.compareTo(value) < 0 ? this.min : value;
                this.max = this.max != null && this.max.compareTo(value) > 0 ? this.max : value;
                this.values.add(value);
            }
            this.average = nonNullCount != 0 ? this.sum.divide(BigDecimal.valueOf(nonNullCount), 2, RoundingMode.HALF_UP) : null;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public BigDecimal getTotal() {
            return this.sum;
        }

        public BigDecimal getAverage() {
            return this.average;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public List<String> getTitles() {
            return Collections.unmodifiableList(this.titles);
        }

        public List<BigDecimal> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List<Number> getValuesAsNumbers() {
            return Summary.asNumbers(this.getValues());
        }

        private static List<Number> asNumbers(List<BigDecimal> values) {
            return _Lists.newArrayList((Iterable)Iterables.transform(values, BIGDECIMAL_TO_NUMBER));
        }
    }
}

