/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.PrototypingMessageProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class IsisTotalRecordsToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String navigatorContainerId = "navigatorContainer";

    public IsisTotalRecordsToolbar(final DataTable<?, ?> table) {
        this(table, (IModel<String>)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return String.format("Showing all of %d", table.getRowCount());
            }
        });
    }

    protected IsisTotalRecordsToolbar(final DataTable<?, ?> table, IModel<String> messageModel) {
        super(table);
        WebMarkupContainer container = new WebMarkupContainer(navigatorContainerId);
        this.add(new Component[]{container});
        container.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel)new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return String.valueOf(table.getColumns().size()).intern();
            }
        })});
        container.add(new Component[]{new Label("navigatorLabel", messageModel)});
        container.add(new Component[]{new Label("prototypingLabel", PrototypingMessageProvider.getTookTimingMessageModel())});
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.getTable().getRowCount() <= 5L) {
            this.setVisible(false);
            return;
        }
        this.setVisible(this.getTable().getPageCount() == 1L);
    }
}

