/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.tablecol.TableColumnOrderService;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.SingleValueFacet;
import org.apache.isis.core.metamodel.facets.WhereValueFacet;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.common.OnConcurrencyExceptionHandler;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterPropertyColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterTitleColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";
    private IsisAjaxFallbackDataTable<ObjectAdapter, String> dataTable;

    public CollectionContentsAsAjaxTablePanel(String id, EntityCollectionModel model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        ArrayList columns = _Lists.newArrayList();
        BulkActionsProvider bulkActionsProvider = this.getBulkActionsProvider();
        ObjectAdapterToggleboxColumn toggleboxColumn = null;
        if (bulkActionsProvider != null) {
            toggleboxColumn = bulkActionsProvider.getToggleboxColumn();
            if (toggleboxColumn != null) {
                columns.add(toggleboxColumn);
            }
            bulkActionsProvider.configureBulkActions(toggleboxColumn);
        }
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        this.addTitleColumn(columns, model.getParentObjectAdapterMemento(), this.getSettings().getMaxTitleLengthInParentedTables(), this.getSettings().getMaxTitleLengthInStandaloneTables());
        this.addPropertyColumnsIfRequired(columns);
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider(model);
        this.dataTable = new IsisAjaxFallbackDataTable(ID_TABLE, columns, dataProvider, model.getPageSize(), toggleboxColumn);
        this.addOrReplace(new Component[]{this.dataTable});
        this.dataTable.honourHints();
        if (toggleboxColumn != null) {
            OnConcurrencyExceptionHandler handler2 = new OnConcurrencyExceptionHandler(){
                private static final long serialVersionUID = 1L;

                public void onConcurrencyException(Component context, ObjectAdapter selectedAdapter, ConcurrencyException ex, AjaxRequestTarget ajaxRequestTarget) {
                    ajaxRequestTarget.add(new Component[]{CollectionContentsAsAjaxTablePanel.this.dataTable});
                }
            };
            toggleboxColumn.setOnConcurrencyExceptionHandler(handler2);
        }
    }

    private BulkActionsProvider getBulkActionsProvider() {
        for (CollectionContentsAsAjaxTablePanel component = this; component != null; component = component.getParent()) {
            if (!(component instanceof BulkActionsProvider)) continue;
            return (BulkActionsProvider)((Object)component);
        }
        return null;
    }

    private void addTitleColumn(List<IColumn<ObjectAdapter, String>> columns, ObjectAdapterMemento parentAdapterMementoIfAny, int maxTitleParented, int maxTitleStandalone) {
        int maxTitleLength = ((EntityCollectionModel)this.getModel()).isParented() ? maxTitleParented : maxTitleStandalone;
        columns.add((IColumn<ObjectAdapter, String>)new ObjectAdapterTitleColumn(parentAdapterMementoIfAny, maxTitleLength));
    }

    private void addPropertyColumnsIfRequired(List<IColumn<ObjectAdapter, String>> columns) {
        Comparator<String> propertyIdComparator;
        ObjectSpecification typeOfSpec = ((EntityCollectionModel)this.getModel()).getTypeOfSpecification();
        GridFacet gridFacet = (GridFacet)typeOfSpec.getFacet(GridFacet.class);
        if (gridFacet != null) {
            EntityModel entityModel = ((EntityCollectionModel)this.getModel()).getEntityModel();
            ObjectAdapter objectAdapterIfAny = entityModel != null ? (ObjectAdapter)entityModel.getObject() : null;
            Grid grid = gridFacet.getGrid((ManagedObject)objectAdapterIfAny);
            HashMap propertyIdOrderWithinGrid = new HashMap();
            grid.getAllPropertiesById().forEach((propertyId, __) -> propertyIdOrderWithinGrid.put(propertyId, propertyIdOrderWithinGrid.size()));
            propertyIdComparator = Comparator.comparingInt(propertyId -> propertyIdOrderWithinGrid.getOrDefault(propertyId, Integer.MAX_VALUE)).thenComparing(Comparator.naturalOrder());
        } else {
            propertyIdComparator = null;
        }
        Where whereContext = ((EntityCollectionModel)this.getModel()).isParented() ? Where.PARENTED_TABLES : Where.STANDALONE_TABLES;
        ObjectSpecification parentSpecIfAny = ((EntityCollectionModel)this.getModel()).isParented() ? ((EntityCollectionModel)this.getModel()).getParentObjectAdapterMemento().getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader()).getSpecification() : null;
        Predicate<ObjectAssociation> predicate = ObjectAssociation.Predicates.PROPERTIES.and(association -> {
            Stream<Facet> facets = association.streamFacets().filter(facet -> facet instanceof WhereValueFacet && facet instanceof HiddenFacet);
            return !facets.map(facet -> (WhereValueFacet)facet).anyMatch(wawF -> wawF.where().includes(whereContext));
        }).and(CollectionContentsAsAjaxTablePanel.associationDoesNotReferenceParent(parentSpecIfAny));
        Stream<ObjectAssociation> propertyList = typeOfSpec.streamAssociations(Contributed.INCLUDED).filter(predicate);
        LinkedHashMap propertyById = _Maps.newLinkedHashMap();
        propertyList.forEach(property -> propertyById.put(property.getId(), property));
        List<Object> propertyIds = _Lists.newArrayList(propertyById.keySet());
        if (propertyIdComparator != null) {
            propertyIds.sort(propertyIdComparator);
        }
        List tableColumnOrderServices = this.getServicesInjector().streamServices(TableColumnOrderService.class).collect(Collectors.toList());
        for (TableColumnOrderService tableColumnOrderService : tableColumnOrderServices) {
            List<String> propertyReorderedIds = this.reordered(tableColumnOrderService, propertyIds);
            if (propertyReorderedIds == null) continue;
            propertyIds = propertyReorderedIds;
            break;
        }
        for (String propertyId2 : propertyIds) {
            ObjectAssociation property2 = (ObjectAssociation)propertyById.get(propertyId2);
            if (property2 == null) continue;
            ObjectAdapterPropertyColumn nopc = this.createObjectAdapterPropertyColumn(property2);
            columns.add((IColumn<ObjectAdapter, String>)nopc);
        }
    }

    private List<String> reordered(TableColumnOrderService tableColumnOrderService, List<String> propertyIds) {
        Class collectionType = ((EntityCollectionModel)this.getModel()).getTypeOfSpecification().getCorrespondingClass();
        ObjectAdapterMemento parentObjectAdapterMemento = ((EntityCollectionModel)this.getModel()).getParentObjectAdapterMemento();
        if (parentObjectAdapterMemento != null) {
            ObjectAdapter parentObjectAdapter = parentObjectAdapterMemento.getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
            Object parent = parentObjectAdapter.getPojo();
            String collectionId = ((EntityCollectionModel)this.getModel()).getCollectionMemento().getId();
            return tableColumnOrderService.orderParented(parent, collectionId, collectionType, propertyIds);
        }
        return tableColumnOrderService.orderStandalone(collectionType, propertyIds);
    }

    static Predicate<ObjectAssociation> associationDoesNotReferenceParent(final ObjectSpecification parentSpec) {
        if (parentSpec == null) {
            return __ -> true;
        }
        return new Predicate<ObjectAssociation>(){

            @Override
            public boolean test(ObjectAssociation association) {
                HiddenFacet facet = (HiddenFacet)association.getFacet(HiddenFacet.class);
                if (facet == null) {
                    return true;
                }
                if (facet.where() != Where.REFERENCES_PARENT) {
                    return true;
                }
                ObjectSpecification assocSpec = association.getSpecification();
                boolean associationSpecIsOfParentSpec = parentSpec.isOfType(assocSpec);
                boolean isVisible = !associationSpecIsOfParentSpec;
                return isVisible;
            }
        };
    }

    private ObjectAdapterPropertyColumn createObjectAdapterPropertyColumn(ObjectAssociation property) {
        NamedFacet facet = (NamedFacet)property.getFacet(NamedFacet.class);
        boolean escaped = facet == null || facet.escaped();
        String parentTypeName = property.getOnType().getSpecId().asString();
        String describedAs = (String)_With.mapIfPresentElse((Object)property.getFacet(DescribedAsFacet.class), SingleValueFacet::value, null);
        return new ObjectAdapterPropertyColumn(((EntityCollectionModel)this.getModel()).getType(), (IModel<String>)Model.of((Serializable)((Object)property.getName())), property.getId(), property.getId(), escaped, parentTypeName, describedAs);
    }

    protected void onModelChanged() {
        this.buildGui();
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }
}

