/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.common.OnSelectionHandler;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ToggledMementosProvider;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelUtil;
import org.apache.isis.viewer.wicket.ui.components.collection.AssociatedWithActionsHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionSelectorProvider,
BulkActionsProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private Component collectionContents;
    private Label label;
    private final AssociatedWithActionsHelper associatedWithActionsHelper;
    private CollectionSelectorPanel selectorDropdownPanel;
    ObjectAdapterToggleboxColumn toggleboxColumn;

    public CollectionPanel(String id, EntityCollectionModel collectionModel) {
        super(id, collectionModel);
        ArrayList entityActionLinks = _Lists.newArrayList();
        OneToManyAssociation otma = collectionModel.getCollectionMemento().getCollection(collectionModel.getSpecificationLoader());
        EntityModel entityModel = collectionModel.getEntityModel();
        ObjectAdapter adapter = entityModel.load(ConcurrencyChecking.NO_CHECK);
        List associatedActions = ObjectAction.Util.findForAssociation((ObjectAdapter)adapter, (ObjectAssociation)otma);
        this.associatedWithActionsHelper = new AssociatedWithActionsHelper(collectionModel);
        MyToggledMementosProvider toggledMementosProvider = new MyToggledMementosProvider(collectionModel, this, this);
        entityActionLinks.addAll(LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(entityModel, associatedActions, null, toggledMementosProvider));
        collectionModel.addLinkAndLabels((List)entityActionLinks);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        this.collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, this.collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.collectionContents))});
        this.setOutputMarkupId(true);
    }

    public Label createLabel(String id, String collectionName) {
        this.label = new Label(id, (Serializable)((Object)collectionName));
        this.label.setOutputMarkupId(true);
        return this.label;
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    public void setSelectorDropdownPanel(CollectionSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }

    @Override
    public ObjectAdapterToggleboxColumn getToggleboxColumn() {
        if (this.toggleboxColumn == null) {
            List<ObjectAction> associatedActions = this.associatedWithActionsHelper.getAssociatedActions(this.getIsisSessionFactory());
            EntityCollectionModel entityCollectionModel = (EntityCollectionModel)this.getModel();
            if (associatedActions.isEmpty() || entityCollectionModel.isStandalone()) {
                return null;
            }
            this.toggleboxColumn = new ObjectAdapterToggleboxColumn();
            OnSelectionHandler handler = new OnSelectionHandler(){
                private static final long serialVersionUID = 1L;

                public void onSelected(Component context, ObjectAdapter selectedAdapter, AjaxRequestTarget ajaxRequestTarget) {
                    ((EntityCollectionModel)CollectionPanel.this.getModel()).toggleSelectionOn(selectedAdapter);
                }
            };
            this.toggleboxColumn.setOnSelectionHandler(handler);
        }
        return this.toggleboxColumn;
    }

    @Override
    public void configureBulkActions(ObjectAdapterToggleboxColumn toggleboxColumn) {
    }

    private static class MyToggledMementosProvider
    implements ToggledMementosProvider,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EntityCollectionModel collectionModel;
        private final BulkActionsProvider bulkActionsProvider;
        private final CollectionPanel collectionPanel;

        MyToggledMementosProvider(EntityCollectionModel collectionModel, BulkActionsProvider bulkActionsProvider, CollectionPanel collectionPanel) {
            this.collectionModel = collectionModel;
            this.bulkActionsProvider = bulkActionsProvider;
            this.collectionPanel = collectionPanel;
        }

        public List<ObjectAdapterMemento> getToggles() {
            return this.collectionModel.getToggleMementosList();
        }

        public void clearToggles(AjaxRequestTarget target) {
            this.collectionModel.clearToggleMementosList();
            ObjectAdapterToggleboxColumn toggleboxColumn = this.bulkActionsProvider.getToggleboxColumn();
            if (toggleboxColumn != null) {
                toggleboxColumn.clearToggles();
                target.add(new Component[]{this.collectionPanel});
            }
        }
    }
}

