/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.ListOfLinksModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsDropDownPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsListInlinePanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.Model;

public class AdditionalLinksPanel
extends PanelAbstract<ListOfLinksModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINK_LIST = "additionalLinkList";
    private static final String ID_ADDITIONAL_LINK_ITEM = "additionalLinkItem";
    private static final String ID_ADDITIONAL_LINK_TITLE = "additionalLinkTitle";
    public static final String ID_ADDITIONAL_LINK = "additionalLink";

    public static AdditionalLinksPanel addAdditionalLinks(MarkupContainer markupContainer, String id, List<LinkAndLabel> links, Style style) {
        if (links.isEmpty()) {
            Components.permanentlyHide(markupContainer, id);
            return null;
        }
        AdditionalLinksPanel additionalLinksPanel = style.newPanel(id, links);
        markupContainer.addOrReplace(new Component[]{additionalLinksPanel});
        return additionalLinksPanel;
    }

    protected AdditionalLinksPanel(String id, List<LinkAndLabel> linksDoNotUseDirectlyInsteadUseOfListOfLinksModel) {
        super(id, new ListOfLinksModel(linksDoNotUseDirectlyInsteadUseOfListOfLinksModel));
        final List linkAndLabels = (List)((ListOfLinksModel)this.getModel()).getObject();
        WebMarkupContainer container = new WebMarkupContainer(ID_ADDITIONAL_LINK_LIST){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                for (LinkAndLabel linkAndLabel : linkAndLabels) {
                    AbstractLink link = linkAndLabel.getLink();
                    if (!link.isVisible()) continue;
                    return true;
                }
                return false;
            }
        };
        this.addOrReplace(new Component[]{container});
        container.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        ListView<LinkAndLabel> listView = new ListView<LinkAndLabel>(ID_ADDITIONAL_LINK_ITEM, linkAndLabels){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<LinkAndLabel> item) {
                final LinkAndLabel linkAndLabel = (LinkAndLabel)item.getModelObject();
                final AbstractLink link = linkAndLabel.getLink();
                Model<String> tooltipModel = link instanceof ActionLink ? new Model<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        ActionLink actionLink = (ActionLink)link;
                        String reasonDisabledIfAny = actionLink.getReasonDisabledIfAny();
                        return AdditionalLinksPanel.first(new String[]{reasonDisabledIfAny, linkAndLabel.getDescriptionIfAny()});
                    }
                } : Model.of((Serializable)((Object)AdditionalLinksPanel.first(new String[]{linkAndLabel.getReasonDisabledIfAny(), linkAndLabel.getDescriptionIfAny()})));
                Tooltips.addTooltip((Component)link, tooltipModel);
                Label viewTitleLabel = new Label(AdditionalLinksPanel.ID_ADDITIONAL_LINK_TITLE, (Serializable)((Object)linkAndLabel.getLabel()));
                if (linkAndLabel.isBlobOrClob()) {
                    link.add(new Behavior[]{new CssClassAppender("noVeil")});
                }
                if (linkAndLabel.isPrototype()) {
                    link.add(new Behavior[]{new CssClassAppender("prototype")});
                }
                link.add(new Behavior[]{new CssClassAppender(linkAndLabel.getActionIdentifier())});
                SemanticsOf semantics = linkAndLabel.getSemantics();
                if (linkAndLabel.getParameters().isNoParameters() && linkAndLabel.getReasonDisabledIfAny() == null) {
                    AdditionalLinksPanel.this.addConfirmationDialogIfAreYouSureSemantics((Component)link, semantics);
                }
                String cssClass = linkAndLabel.getCssClass();
                CssClassAppender.appendCssClassTo((MarkupContainer)link, cssClass);
                link.addOrReplace(new Component[]{viewTitleLabel});
                String cssClassFa = linkAndLabel.getCssClassFa();
                if (_Strings.isNullOrEmpty((CharSequence)cssClassFa)) {
                    viewTitleLabel.add(new Behavior[]{new CssClassAppender("menuLinkSpacer")});
                } else {
                    CssClassFaPosition position = linkAndLabel.getCssClassFaPosition();
                    viewTitleLabel.add(new Behavior[]{new CssClassFaBehavior(cssClassFa, position)});
                }
                item.addOrReplace(new Component[]{link});
            }
        };
        container.addOrReplace(new Component[]{listView});
    }

    private static String first(String ... str) {
        for (String s : str) {
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static enum Style {
        INLINE_LIST{

            @Override
            AdditionalLinksPanel newPanel(String id, List<LinkAndLabel> links) {
                return new AdditionalLinksAsListInlinePanel(id, links);
            }
        }
        ,
        DROPDOWN{

            @Override
            AdditionalLinksPanel newPanel(String id, List<LinkAndLabel> links) {
                return new AdditionalLinksAsDropDownPanel(id, links);
            }
        };


        abstract AdditionalLinksPanel newPanel(String var1, List<LinkAndLabel> var2);
    }
}

