/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionlink;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ActionLinkPanel
extends PanelAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_LINK_WRAPPER = "actionLinkWrapper";
    private static final String ID_ACTION_LINK = "actionLink";
    private static final String ID_ACTION_TITLE = "actionTitle";
    private Label label;

    public ActionLinkPanel(String id, ActionModel actionModel) {
        super(id, actionModel);
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceLinkWrapper();
    }

    private void addOrReplaceLinkWrapper() {
        WebMarkupContainer entityLinkWrapper = this.addOrReplaceLinkWrapper((ActionModel)this.getModel());
        this.addOrReplace(new Component[]{entityLinkWrapper});
    }

    private WebMarkupContainer addOrReplaceLinkWrapper(ActionModel actionModel) {
        PageParameters pageParameters = actionModel.getPageParameters();
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ACTION_PROMPT);
        AbstractLink link = this.newLink(ID_ACTION_LINK, pageClass, pageParameters);
        this.label = new Label(ID_ACTION_TITLE, (Serializable)((Object)this.determineTitle()));
        link.add(new Component[]{this.label});
        WebMarkupContainer actionLinkWrapper = new WebMarkupContainer(ID_ACTION_LINK_WRAPPER);
        actionLinkWrapper.addOrReplace(new Component[]{link});
        return actionLinkWrapper;
    }

    private String determineTitle() {
        return ((ActionModel)this.getModel()).getActionMemento().getAction(this.getSpecificationLoader()).getId();
    }

    private AbstractLink newLink(String linkId, Class<? extends Page> pageClass, PageParameters pageParameters) {
        return Links.newBookmarkablePageLink(linkId, pageParameters, pageClass);
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }
}

