/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.about;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.AboutModel;
import org.apache.isis.viewer.wicket.ui.components.about.JarManifestModel;
import org.apache.isis.viewer.wicket.ui.components.about.JarManifestPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;

public class AboutPanel
extends PanelAbstract<AboutModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_MANIFEST_ATTRIBUTES = "manifestAttributes";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationVersion")
    private String applicationVersion;
    @Inject
    @Named(value="aboutMessage")
    private String aboutMessage;
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_APPLICATION_VERSION = "applicationVersion";
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    @Inject
    @Named(value="metaInfManifest")
    private transient InputStream metaInfManifestIs;
    private JarManifestModel jarManifestModel;

    public AboutPanel(String id) {
        super(id);
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_APPLICATION_NAME, this.applicationName)});
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_APPLICATION_VERSION, this.applicationVersion)});
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_ABOUT_MESSAGE, this.aboutMessage)});
        if (this.jarManifestModel == null) {
            this.jarManifestModel = new JarManifestModel(this.metaInfManifestIs);
        }
        this.add(new Component[]{new JarManifestPanel(ID_MANIFEST_ATTRIBUTES, this.jarManifestModel)});
    }

    public static class LabelVisibleOnlyIfNonEmpty
    extends Label {
        private final String label;

        public LabelVisibleOnlyIfNonEmpty(String id, String label) {
            super(id, (Serializable)((Object)label));
            this.label = label;
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setVisibilityAllowed(this.label != null && !this.label.isEmpty());
        }
    }
}

