/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.links.Link;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.menubars.MenuBarsResource;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.serialization.SerializationStrategy;

public class MenuBarsResourceServerside
extends ResourceAbstract
implements MenuBarsResource {
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/layout-menubars", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/layout-menubars"})
    public Response menuBars() {
        this.init(RepresentationType.MENUBARS, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        SerializationStrategy serializationStrategy = SerializationStrategy.determineFrom(this.getResourceContext().getAcceptableMediaTypes());
        MenuBarsService menuBarsService = (MenuBarsService)this.getResourceContext().getServicesInjector().lookupServiceElseFail(MenuBarsService.class);
        MenuBars menuBars = menuBarsService.menuBars();
        this.addLinksForServiceActions(menuBars);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity(serializationStrategy.entity(menuBars)).type(serializationStrategy.type(RepresentationType.MENUBARS));
        return builder.build();
    }

    void addLinksForServiceActions(MenuBars menuBars) {
        menuBars.visit(new MenuBars.Visitor(){

            public void visit(ServiceActionLayoutData actionLayoutData) {
                String objectType = actionLayoutData.getObjectType();
                String relativeUrl = String.format("objects/%s/%s/actions/%s", objectType, "1", actionLayoutData.getId());
                Link link = new Link(Rel.ACTION.getName(), RestfulHttpMethod.GET.getJavaxRsMethod(), MenuBarsResourceServerside.this.getResourceContext().urlFor(relativeUrl), RepresentationType.OBJECT_ACTION.getJsonMediaType().toString());
                actionLayoutData.setLink(link);
            }
        });
    }

    public Response deleteMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the menuBars resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the menuBars resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the menuBars resource is not allowed.", (Object[])new Object[0]);
    }
}

