/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.server.util.OidUtils;

public class JsonParserHelper {
    private static final Pattern OBJECT_OID = Pattern.compile(".*objects\\/([^/]+)\\/(.+)");
    private final RendererContext rendererContext;
    private final ObjectSpecification objectSpec;

    public JsonParserHelper(RendererContext rendererContext, ObjectSpecification objectSpecification) {
        this.objectSpec = objectSpecification;
        this.rendererContext = rendererContext;
    }

    ObjectAdapter parseAsMapWithSingleValue(String bodyAsString) {
        JsonRepresentation arguments = Util.readAsMap((String)bodyAsString);
        return this.parseAsMapWithSingleValue(arguments);
    }

    ObjectAdapter parseAsMapWithSingleValue(JsonRepresentation arguments) {
        JsonRepresentation representation = arguments.getRepresentation("value", new Object[0]);
        if (arguments.size() != 1 || representation == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body should be a map with a single key 'value' whose value represents an instance of type '%s'", (Object[])new Object[]{JsonParserHelper.resourceFor(this.objectSpec)});
        }
        return this.objectAdapterFor(arguments);
    }

    public ObjectAdapter objectAdapterFor(JsonRepresentation argRepr) {
        if (argRepr == null) {
            return null;
        }
        if (!argRepr.mapHas("value")) {
            String reason = "No 'value' key";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        if (this.objectSpec == null) {
            String reason = "ObjectSpec is null, cannot validate";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        JsonRepresentation argValueRepr = argRepr.getRepresentation("value", new Object[0]);
        if (this.objectSpec.isEncodeable()) {
            try {
                return JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)argValueRepr, null);
            }
            catch (IllegalArgumentException ex) {
                argRepr.mapPut("invalidReason", ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                StringBuilder buf = new StringBuilder("Failed to parse representation ");
                try {
                    String reprStr = argRepr.getString("value");
                    buf.append("'").append(reprStr).append("' ");
                }
                catch (Exception reprStr) {
                    // empty catch block
                }
                buf.append("as value of type '").append(this.objectSpec.getShortIdentifier()).append("'");
                String reason = buf.toString();
                argRepr.mapPut("invalidReason", reason);
                throw new IllegalArgumentException(reason);
            }
        }
        if (!argValueRepr.isLink()) {
            String reason = "Expected a link (because this object's type is not a value) but found no 'href'";
            argRepr.mapPut("invalidReason", "Expected a link (because this object's type is not a value) but found no 'href'");
            throw new IllegalArgumentException("Expected a link (because this object's type is not a value) but found no 'href'");
        }
        String oidFromHref = JsonParserHelper.encodedOidFromLink(argValueRepr);
        if (oidFromHref == null) {
            String reason = "Could not parse 'href' to identify the object's OID";
            argRepr.mapPut("invalidReason", "Could not parse 'href' to identify the object's OID");
            throw new IllegalArgumentException("Could not parse 'href' to identify the object's OID");
        }
        ObjectAdapter objectAdapter = OidUtils.getObjectAdapterElseNull(this.rendererContext, oidFromHref);
        if (objectAdapter == null) {
            String reason = "'href' does not reference a known entity";
            argRepr.mapPut("invalidReason", "'href' does not reference a known entity");
            throw new IllegalArgumentException("'href' does not reference a known entity");
        }
        return objectAdapter;
    }

    static String encodedOidFromLink(JsonRepresentation link) {
        String href = link.getString("href");
        Matcher matcher = OBJECT_OID.matcher(href);
        if (!matcher.matches()) {
            return null;
        }
        String domainType = matcher.group(1);
        String instanceId = matcher.group(2);
        return Oid.marshaller().joinAsOid(domainType, instanceId);
    }

    private static String resourceFor(ObjectSpecification objectSpec) {
        return objectSpec.getFullIdentifier();
    }
}

