/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.core.commons.url.UrlDecoderUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainServiceResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainServicesListReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;

@Path(value="/services")
public class DomainServiceResourceServerside
extends ResourceAbstract
implements DomainServiceResource {
    private static final Predicate<ObjectAdapter> NATURE_OF_MENU = input -> {
        ObjectSpecification specification = input.getSpecification();
        DomainServiceFacet facet = (DomainServiceFacet)specification.getFacet(DomainServiceFacet.class);
        if (facet == null) {
            return false;
        }
        NatureOfService natureOfService = facet.getNatureOfService();
        return natureOfService == NatureOfService.VIEW || natureOfService == NatureOfService.VIEW_MENU_ONLY || natureOfService == NatureOfService.VIEW_REST_ONLY;
    };

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/list", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response services() {
        this.init(RepresentationType.LIST, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        Stream<ObjectAdapter> serviceAdapters = this.getResourceContext().streamServiceAdapters().filter(NATURE_OF_MENU);
        DomainServicesListReprRenderer renderer = new DomainServicesListReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ListReprRenderer)renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).includesSelf()).with(serviceAdapters);
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build();
    }

    public Response deleteServicesNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the services resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putServicesNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the services resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postServicesNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the services resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response service(@PathParam(value="serviceId") String serviceId) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).with(serviceAdapter).includesSelf();
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build();
    }

    public Response deleteServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting a service resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to a service resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to a service resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-action", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response actionPrompt(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        this.init(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(serviceAdapter);
        return helper.actionPrompt(actionId);
    }

    public Response deleteActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisUrlEncodedQueryString) {
        String urlUnencodedQueryString = UrlDecoderUtil.urlDecodeNullSafe((String)(xIsisUrlEncodedQueryString != null ? xIsisUrlEncodedQueryString : this.httpServletRequest.getQueryString()));
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, urlUnencodedQueryString);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(serviceAdapter);
        return helper.invokeActionQueryOnly(actionId, arguments);
    }

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, body);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(serviceAdapter);
        return helper.invokeActionIdempotent(actionId, arguments);
    }

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeAction(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, body);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter serviceAdapter = this.getServiceAdapter(serviceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(serviceAdapter);
        return helper.invokeAction(actionId, arguments);
    }

    public Response deleteInvokeActionNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting an action invocation resource is not allowed.", (Object[])new Object[0]);
    }

    private DomainResourceHelper newDomainResourceHelper(ObjectAdapter serviceAdapter) {
        return new DomainResourceHelper(this.getResourceContext(), serviceAdapter, (ObjectAdapterLinkTo)new DomainServiceLinkTo());
    }
}

