/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.valuetypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.isis.applib.value.Money;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

public class IsisMoneyMapping
extends SingleFieldMultiMapping {
    public Class<?> getJavaType() {
        return Money.class;
    }

    public void initialize(AbstractMemberMetaData mmd, Table container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    private void addColumns() {
        this.addColumns(ClassNameConstants.JAVA_LANG_LONG);
        this.addColumnWithLength(ClassNameConstants.JAVA_LANG_STRING, 3);
    }

    public void addColumnWithLength(String typeName, int columnLength) {
        MappingManager mgr = this.getStoreManager().getMappingManager();
        Column column = null;
        if (this.table != null) {
            column = mgr.createColumn((JavaTypeMapping)this, typeName, this.getNumberOfColumnMappings());
            column.setColumnMetaData(column.getColumnMetaData().setLength(Integer.valueOf(columnLength)));
        }
        mgr.createColumnMapping((JavaTypeMapping)this, column, typeName);
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Money m = (Money)value;
        switch (index) {
            case 0: {
                return m.longValue();
            }
            case 1: {
                return m.getCurrency();
            }
        }
        throw new IndexOutOfBoundsException("Wrong index: " + index);
    }

    public void setObject(ExecutionContext ec, PreparedStatement preparedStmt, int[] exprIndex, Object value) {
        if (value instanceof Money) {
            Money m = (Money)value;
            this.getColumnMapping(0).setLong(preparedStmt, exprIndex[0], m.longValue());
            this.getColumnMapping(1).setString(preparedStmt, exprIndex[1], m.getCurrency());
        } else {
            this.getColumnMapping(0).setLong(preparedStmt, exprIndex[0], 0L);
            this.getColumnMapping(1).setString(preparedStmt, exprIndex[1], null);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        try {
            if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null || this.getColumnMapping(1).getObject(resultSet, exprIndex[1]) == null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long amount = this.getColumnMapping(0).getLong(resultSet, exprIndex[0]);
        String currency = this.getColumnMapping(1).getString(resultSet, exprIndex[1]);
        if (currency == null) {
            return null;
        }
        return new Money(Long.valueOf(amount).doubleValue() / 100.0, currency);
    }
}

