/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import java.util.List;
import javax.jdo.JDOQLTypedQuery;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport_v3_2;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession5;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFindAllInstancesProcessor
extends PersistenceQueryProcessorAbstract<PersistenceQueryFindAllInstances> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFindAllInstancesProcessor.class);

    public PersistenceQueryFindAllInstancesProcessor(PersistenceSession5 persistenceSession) {
        super(persistenceSession);
    }

    public List<ObjectAdapter> process(PersistenceQueryFindAllInstances persistenceQuery) {
        IsisJdoSupport_v3_2 isisJdoSupport = PersistenceQueryFindAllInstancesProcessor.isisJdoSupport();
        ObjectSpecification specification = persistenceQuery.getSpecification();
        Class cls = specification.getCorrespondingClass();
        JDOQLTypedQuery typesafeQuery = isisJdoSupport.newTypesafeQuery(cls);
        isisJdoSupport.disableMultivaluedFetch(typesafeQuery);
        if (LOG.isDebugEnabled()) {
            LOG.debug("allInstances(): class={}", (Object)specification.getFullIdentifier());
        }
        List pojos = isisJdoSupport.executeQuery(cls);
        return this.loadAdapters(pojos);
    }
}

