/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.DNStoreManagerType;
import org.apache.isis.objectstore.jdo.datanucleus.CreateSchemaObjectFromClassMetadata;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusLifeCycleHelper;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPropertiesAware;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryFacet;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

public class DataNucleusApplicationComponents5
implements ApplicationScopedComponent {
    public static final String CLASS_METADATA_LOADED_LISTENER_KEY = "classMetadataLoadedListener";
    static final String CLASS_METADATA_LOADED_LISTENER_DEFAULT = CreateSchemaObjectFromClassMetadata.class.getName();
    private static DataNucleusApplicationComponents5 instance;
    private boolean stale = false;
    private final Set<String> persistableClassNameSet;
    private final IsisConfiguration jdoObjectstoreConfig;
    private final Map<String, String> datanucleusProps;
    private PersistenceManagerFactory persistenceManagerFactory;

    public static MetaDataManager getMetaDataManager() {
        return instance != null ? ((JDOPersistenceManagerFactory)DataNucleusApplicationComponents5.instance.persistenceManagerFactory).getNucleusContext().getMetaDataManager() : null;
    }

    public static void markAsStale() {
        if (instance != null) {
            DataNucleusApplicationComponents5.instance.stale = true;
        }
    }

    public boolean isStale() {
        return this.stale;
    }

    public DataNucleusApplicationComponents5(IsisConfiguration configuration, Map<String, String> datanucleusProps, Set<String> persistableClassNameSet) {
        this.datanucleusProps = datanucleusProps;
        this.persistableClassNameSet = persistableClassNameSet;
        this.jdoObjectstoreConfig = configuration;
        this.persistenceManagerFactory = this.createPmfAndSchemaIfRequired(this.persistableClassNameSet, this.datanucleusProps);
        instance = this;
    }

    public void shutdown() {
        instance = null;
        if (this.persistenceManagerFactory != null) {
            DataNucleusLifeCycleHelper.cleanUp(this.persistenceManagerFactory);
            this.persistenceManagerFactory = null;
        }
    }

    static PersistenceManagerFactory newPersistenceManagerFactory(Map<String, String> datanucleusProps) {
        return JDOHelper.getPersistenceManagerFactory(datanucleusProps, (ClassLoader)IsisContext.getClassLoader());
    }

    private PersistenceManagerFactory createPmfAndSchemaIfRequired(Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        PersistenceManagerFactory persistenceManagerFactory;
        DNStoreManagerType dnStoreManagerType = DNStoreManagerType.typeOf(datanucleusProps);
        if (dnStoreManagerType.isSchemaAware()) {
            boolean createSchema = this.isSet(datanucleusProps, "datanucleus.schema.autoCreateAll");
            if (createSchema) {
                this.configureAutoCreateSchema(datanucleusProps);
                persistenceManagerFactory = DataNucleusApplicationComponents5.newPersistenceManagerFactory(datanucleusProps);
                this.createSchema(persistenceManagerFactory, persistableClassNameSet, datanucleusProps);
            } else {
                persistenceManagerFactory = DataNucleusApplicationComponents5.newPersistenceManagerFactory(datanucleusProps);
            }
        } else {
            this.configureAutoStart(persistableClassNameSet, datanucleusProps);
            persistenceManagerFactory = DataNucleusApplicationComponents5.newPersistenceManagerFactory(this.datanucleusProps);
        }
        return persistenceManagerFactory;
    }

    private void configureAutoCreateSchema(Map<String, String> datanucleusProps) {
        datanucleusProps.put("datanucleus.schema.autoCreateAll", "false");
        datanucleusProps.put("datanucleus.schema.autoCreateDatabase", "false");
        datanucleusProps.put("datanucleus.schema.autoCreateTables", "true");
        datanucleusProps.put("datanucleus.schema.autoCreateColumns", "true");
        datanucleusProps.put("datanucleus.schema.autoCreateConstraints", "true");
    }

    private void configureAutoStart(Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        String persistableClassNames = _NullSafe.stream(persistableClassNameSet).collect(Collectors.joining(","));
        datanucleusProps.put("datanucleus.autoStartMechanism", "Classes");
        datanucleusProps.put("datanucleus.autoStartMechanismMode", "Checked");
        datanucleusProps.put("datanucleus.autoStartClassNames", persistableClassNames);
    }

    private void createSchema(PersistenceManagerFactory persistenceManagerFactory, Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        JDOPersistenceManagerFactory jdopmf = (JDOPersistenceManagerFactory)persistenceManagerFactory;
        PersistenceNucleusContext nucleusContext = jdopmf.getNucleusContext();
        SchemaAwareStoreManager schemaAwareStoreManager = (SchemaAwareStoreManager)nucleusContext.getStoreManager();
        MetaDataManager metaDataManager = nucleusContext.getMetaDataManager();
        this.registerMetadataListener(metaDataManager, datanucleusProps);
        schemaAwareStoreManager.createSchemaForClasses(persistableClassNameSet, DataNucleusApplicationComponents5.asProperties(datanucleusProps));
    }

    private boolean isSet(Map<String, String> props, String key) {
        return Boolean.parseBoolean(props.get(key));
    }

    private void registerMetadataListener(MetaDataManager metaDataManager, Map<String, String> datanucleusProps) {
        MetaDataListener listener = this.createMetaDataListener();
        if (listener == null) {
            return;
        }
        if (listener instanceof DataNucleusPropertiesAware) {
            ((DataNucleusPropertiesAware)listener).setDataNucleusProperties(datanucleusProps);
        }
        metaDataManager.registerListener(listener);
    }

    private MetaDataListener createMetaDataListener() {
        String classMetadataListenerClassName = this.jdoObjectstoreConfig.getString(CLASS_METADATA_LOADED_LISTENER_KEY, CLASS_METADATA_LOADED_LISTENER_DEFAULT);
        return classMetadataListenerClassName != null ? (MetaDataListener)InstanceUtil.createInstance((String)classMetadataListenerClassName, MetaDataListener.class, (Object[])new Object[0]) : null;
    }

    private static Properties asProperties(Map<String, String> props) {
        Properties properties = new Properties();
        properties.putAll(props);
        return properties;
    }

    static void catalogNamedQueries(Set<String> persistableClassNames, SpecificationLoader specificationLoader) {
        HashMap namedQueryByName = _Maps.newHashMap();
        for (String persistableClassName : persistableClassNames) {
            ObjectSpecification spec = specificationLoader.loadSpecification(persistableClassName);
            JdoQueryFacet facet = (JdoQueryFacet)spec.getFacet(JdoQueryFacet.class);
            if (facet == null) continue;
            for (JdoNamedQuery namedQuery : facet.getNamedQueries()) {
                namedQueryByName.put(namedQuery.getName(), namedQuery);
            }
        }
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }
}

